/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bytes;

import com.tc.bytes.BufferPool;
import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactoryConfig;
import com.tc.bytes.TCByteBufferImpl;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLoggingService;
import com.tc.util.Assert;
import com.tc.util.ServiceUtil;
import com.tc.util.VicariousThreadLocal;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class TCByteBufferFactory {
    public static final int FIXED_BUFFER_SIZE = 4096;
    private static final int WARN_THRESHOLD = 0xA00000;
    private static final TCByteBuffer[] EMPTY_BB_ARRAY = new TCByteBuffer[0];
    private static final TCByteBuffer ZERO_BYTE_BUFFER = TCByteBufferImpl.wrap(new byte[0]);
    private static final TCLogger logger = ServiceUtil.loadService(TCLoggingService.class).getLogger(TCByteBufferFactory.class);
    private static final boolean disablePooling;
    private static final int poolMaxBufCount;
    private static final int commonPoolMaxBufCount;
    private static final LinkedBlockingQueue directCommonFreePool;
    private static final LinkedBlockingQueue nonDirectCommonFreePool;
    private static final Set<ThreadGroup> handledGroups;
    private static final ThreadLocal directFreePool;
    private static final ThreadLocal nonDirectFreePool;

    private static TCByteBuffer createNewInstance(boolean direct, int capacity, int index, int totalCount) {
        try {
            LinkedBlockingQueue poolQueue = direct ? (LinkedBlockingQueue)directFreePool.get() : (LinkedBlockingQueue)nonDirectFreePool.get();
            TCByteBufferImpl rv = new TCByteBufferImpl(capacity, direct, poolQueue);
            return rv;
        }
        catch (OutOfMemoryError oome) {
            logger.error("OOME trying to allocate " + (direct ? "direct" : "non-direct") + " buffer of size " + capacity + " (index " + index + " of count " + totalCount + ")");
            throw oome;
        }
    }

    private static TCByteBufferFactoryConfig getConfig() {
        return ServiceUtil.loadService(TCByteBufferFactoryConfig.class);
    }

    public static TCByteBuffer getInstance(boolean direct, int size) {
        if (size > 0xA00000) {
            logger.warn("Asking for a large amount of memory: " + size + " bytes");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Requested length cannot be less than zero");
        }
        if (size == 0) {
            return ZERO_BYTE_BUFFER;
        }
        if (disablePooling || size < 3596 || size > 4096) {
            return TCByteBufferFactory.createNewInstance(direct, size);
        }
        return TCByteBufferFactory.getFromPoolOrCreate(direct);
    }

    private static TCByteBuffer getFromPoolOrCreate(boolean direct) {
        return TCByteBufferFactory.getFromPoolOrCreate(direct, 0, 1);
    }

    private static TCByteBuffer getFromPoolOrCreate(boolean direct, int i, int numBuffers) {
        TCByteBuffer buffer = TCByteBufferFactory.getFromPool(direct);
        if (null == buffer) {
            buffer = TCByteBufferFactory.createNewInstance(direct, 4096, i, numBuffers);
        }
        return buffer;
    }

    private static TCByteBuffer createNewInstance(boolean direct, int bufferSize) {
        return TCByteBufferFactory.createNewInstance(direct, bufferSize, 0, 1);
    }

    public static void registerThreadGroup(ThreadGroup group) {
        handledGroups.add(group);
    }

    public static TCByteBuffer[] getFixedSizedInstancesForLength(boolean direct, int length) {
        int i;
        if (length > 0xA00000) {
            logger.warn("Asking for a large amount of memory: " + length + " bytes");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Requested length cannot be less than zero");
        }
        if (length == 0) {
            return EMPTY_BB_ARRAY;
        }
        int numBuffers = TCByteBufferFactory.getBufferCountNeededForMessageSize(length);
        TCByteBuffer[] rv = new TCByteBuffer[numBuffers];
        if (disablePooling) {
            for (i = 0; i < numBuffers; ++i) {
                rv[i] = TCByteBufferFactory.createNewInstance(direct, 4096, i, numBuffers);
            }
        } else {
            for (i = 0; i < numBuffers; ++i) {
                rv[i] = TCByteBufferFactory.getFromPoolOrCreate(direct, i, numBuffers);
            }
        }
        TCByteBuffer lastBuffer = rv[rv.length - 1];
        lastBuffer.limit(lastBuffer.capacity() - (numBuffers * 4096 - length));
        return rv;
    }

    private static int getBufferCountNeededForMessageSize(int length) {
        int numBuffers = length / 4096;
        if (length % 4096 != 0) {
            ++numBuffers;
        }
        return numBuffers;
    }

    public static int getTotalBufferSizeNeededForMessageSize(int length) {
        return TCByteBufferFactory.getBufferCountNeededForMessageSize(length) * 4096;
    }

    private static TCByteBuffer getFromPool(boolean direct) {
        if (disablePooling) {
            return null;
        }
        TCByteBuffer buf = null;
        LinkedBlockingQueue poolQueue = direct ? (LinkedBlockingQueue)directFreePool.get() : (LinkedBlockingQueue)nonDirectFreePool.get();
        Assert.assertNotNull(poolQueue);
        try {
            buf = (TCByteBuffer)poolQueue.poll(0L, TimeUnit.MILLISECONDS);
            if (buf != null) {
                buf.checkedOut();
            }
        }
        catch (InterruptedException e) {
            logger.warn("interrupted while getting buffer from pool");
            Thread.currentThread().interrupt();
            return null;
        }
        return buf;
    }

    public static void returnBuffers(TCByteBuffer[] buffers) {
        if (disablePooling) {
            return;
        }
        for (TCByteBuffer buf : buffers) {
            TCByteBufferFactory.returnBuffer(buf);
        }
    }

    public static void returnBuffer(TCByteBuffer buf) {
        if (disablePooling) {
            return;
        }
        if (buf.capacity() == 4096) {
            BufferPool bufferPool = buf.getBufferPool();
            buf.commit();
            if (bufferPool != null) {
                try {
                    bufferPool.offer(buf);
                }
                catch (InterruptedException e) {
                    logger.warn("interrupted while trying to return buffer", e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static TCByteBuffer wrap(byte[] buf) {
        return TCByteBufferImpl.wrap(buf);
    }

    public static TCByteBuffer copyAndWrap(byte[] buf) {
        TCByteBuffer rv = null;
        if (buf != null) {
            rv = TCByteBufferFactory.getInstance(false, buf.length);
            rv.put(buf).rewind();
        } else {
            rv = TCByteBufferFactory.getInstance(false, 0);
        }
        return rv;
    }

    static {
        TCByteBufferFactoryConfig config = TCByteBufferFactory.getConfig();
        disablePooling = config.isDisabled();
        poolMaxBufCount = config.getPoolMaxBufCount();
        commonPoolMaxBufCount = config.getCommonPoolMaxBufCount();
        directCommonFreePool = new LinkedBlockingQueue(commonPoolMaxBufCount);
        nonDirectCommonFreePool = new LinkedBlockingQueue(commonPoolMaxBufCount);
        handledGroups = Collections.newSetFromMap(new WeakHashMap());
        directFreePool = new VicariousThreadLocal(){

            @Override
            protected Object initialValue() {
                if (handledGroups.contains(Thread.currentThread().getThreadGroup())) {
                    return new LinkedBlockingQueue(poolMaxBufCount);
                }
                logger.debug("Buf pool direct for " + Thread.currentThread().getName() + " - using Common Pool");
                return directCommonFreePool;
            }
        };
        nonDirectFreePool = new VicariousThreadLocal(){

            @Override
            protected Object initialValue() {
                if (handledGroups.contains(Thread.currentThread().getThreadGroup())) {
                    return new LinkedBlockingQueue(poolMaxBufCount);
                }
                logger.debug("Buf pool nonDirect for " + Thread.currentThread().getName() + " - using Common Pool");
                return nonDirectCommonFreePool;
            }
        };
    }
}

