/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.merge;

import java.util.Iterator;
import org.codehaus.cargo.module.internal.util.xml.AbstractElement;
import org.codehaus.cargo.module.internal.util.xml.AbstractNodeList;
import org.codehaus.cargo.module.merge.AbstractMergeSet;
import org.codehaus.cargo.module.merge.MergePair;
import org.w3c.dom.Element;

public class MergeNodeList
extends AbstractMergeSet {
    private AbstractNodeList leftSet;
    private AbstractNodeList rightSet;

    protected MergeNodeList(AbstractNodeList leftSet, AbstractNodeList rightSet) {
        this.leftSet = leftSet;
        this.rightSet = rightSet;
    }

    public static final AbstractMergeSet createFromNames(AbstractNodeList leftSet, AbstractNodeList rightSet) {
        MergeNodeList results = new MergeNodeList(leftSet, rightSet);
        Iterator i = leftSet.iterator();
        while (i.hasNext()) {
            AbstractElement left = (AbstractElement)i.next();
            AbstractElement right = rightSet.getByElementId(left.getElementId());
            if (right == null) {
                results.inLeftOnly.add(left);
                continue;
            }
            results.inBoth.add(new MergePair(left, right));
        }
        i = rightSet.iterator();
        while (i.hasNext()) {
            AbstractElement right = (AbstractElement)i.next();
            AbstractElement left = leftSet.getByElementId(right.getElementId());
            if (left != null) continue;
            results.inRightOnly.add(right);
        }
        return results;
    }

    public void add(Element e) {
        this.leftSet.add(e);
    }

    public void remove(Element e) {
        this.leftSet.remove(e);
    }
}

