/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.spi;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.generic.internal.util.ContainerIdentity;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.util.log.LoggedObject;

public abstract class AbstractGenericHintFactory
extends LoggedObject {
    private Map mappings = new HashMap();

    protected AbstractGenericHintFactory() {
    }

    protected boolean hasMapping(RegistrationKey key) {
        return this.getMappings().containsKey(key);
    }

    protected Class getMapping(RegistrationKey key) {
        return (Class)this.getMappings().get(key);
    }

    protected Map getMappings() {
        return this.mappings;
    }

    protected void registerImplementation(RegistrationKey key, Class implementationClass) {
        this.getMappings().put(key, implementationClass);
    }

    protected Object createImplementation(RegistrationKey key, GenericParameters parameters, String implementationConceptName) {
        Object implementation;
        if (!this.getMappings().containsKey(key)) {
            String message = "Cannot create " + implementationConceptName + ". There's no registered " + implementationConceptName + " for the parameters " + "(" + key.toString(implementationConceptName) + "). ";
            Iterator hints = this.getHints(key.getContainerIdentity()).iterator();
            if (hints.hasNext()) {
                message = message + "Valid types for this " + implementationConceptName + " are: \n";
                while (hints.hasNext()) {
                    String hint = (String)hints.next();
                    message = message + "  - " + hint;
                    if (!hints.hasNext()) continue;
                    message = message + "\n";
                }
            } else {
                message = message + "Actually there are no valid types registered for this " + implementationConceptName + ". Maybe you've made a mistake spelling it?";
            }
            throw new ContainerException(message);
        }
        Class implementationClass = (Class)this.getMappings().get(key);
        try {
            Constructor constructor = this.getConstructor(implementationClass, key.getHint(), parameters);
            implementation = this.createInstance(constructor, key.getHint(), parameters);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create " + implementationConceptName + " for the parameters (" + key.toString(implementationConceptName) + ").", e);
        }
        return implementation;
    }

    protected abstract Constructor getConstructor(Class var1, String var2, GenericParameters var3) throws NoSuchMethodException;

    protected abstract Object createInstance(Constructor var1, String var2, GenericParameters var3) throws Exception;

    private List getHints(ContainerIdentity containerIdentity) {
        ArrayList<String> hints = new ArrayList<String>();
        for (RegistrationKey key : this.getMappings().keySet()) {
            if (!key.getContainerIdentity().equals(containerIdentity)) continue;
            hints.add(key.getHint());
        }
        return hints;
    }

    public static interface GenericParameters {
    }
}

