/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.generic.ContainerFactory;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.internal.util.SimpleContainerIdentity;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;

public class DefaultContainerFactory
extends AbstractIntrospectionGenericHintFactory
implements ContainerFactory {
    public DefaultContainerFactory() {
        this.registerContainer("geronimo1x", ContainerType.INSTALLED, "org.codehaus.cargo.container.geronimo.Geronimo1xInstalledLocalContainer");
        this.registerContainer("jboss3x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBoss3xInstalledLocalContainer");
        this.registerContainer("jboss4x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBoss4xInstalledLocalContainer");
        this.registerContainer("jboss4x", ContainerType.REMOTE, "org.codehaus.cargo.container.jboss.JBoss4xRemoteContainer");
        this.registerContainer("jboss42x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBoss42xInstalledLocalContainer");
        this.registerContainer("jboss42x", ContainerType.REMOTE, "org.codehaus.cargo.container.jboss.JBoss42xRemoteContainer");
        this.registerContainer("jboss5x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBoss5xInstalledLocalContainer");
        this.registerContainer("jboss5x", ContainerType.REMOTE, "org.codehaus.cargo.container.jboss.JBoss5xRemoteContainer");
        this.registerContainer("jboss51x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBoss51xInstalledLocalContainer");
        this.registerContainer("jboss51x", ContainerType.REMOTE, "org.codehaus.cargo.container.jboss.JBoss51xRemoteContainer");
        this.registerContainer("jboss6x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jboss.JBoss6xInstalledLocalContainer");
        this.registerContainer("jboss6x", ContainerType.REMOTE, "org.codehaus.cargo.container.jboss.JBoss6xRemoteContainer");
        this.registerContainer("jetty4x", ContainerType.EMBEDDED, "org.codehaus.cargo.container.jetty.Jetty4xEmbeddedLocalContainer");
        this.registerContainer("jetty5x", ContainerType.EMBEDDED, "org.codehaus.cargo.container.jetty.Jetty5xEmbeddedLocalContainer");
        this.registerContainer("jetty6x", ContainerType.EMBEDDED, "org.codehaus.cargo.container.jetty.Jetty6xEmbeddedLocalContainer");
        this.registerContainer("jo1x", ContainerType.INSTALLED, "org.codehaus.cargo.container.jo.Jo1xInstalledLocalContainer");
        this.registerContainer("oc4j9x", ContainerType.INSTALLED, "org.codehaus.cargo.container.orion.Oc4j9xInstalledLocalContainer");
        this.registerContainer("orion1x", ContainerType.INSTALLED, "org.codehaus.cargo.container.orion.Orion1xInstalledLocalContainer");
        this.registerContainer("orion2x", ContainerType.INSTALLED, "org.codehaus.cargo.container.orion.Orion2xInstalledLocalContainer");
        this.registerContainer("resin2x", ContainerType.INSTALLED, "org.codehaus.cargo.container.resin.Resin2xInstalledLocalContainer");
        this.registerContainer("resin3x", ContainerType.INSTALLED, "org.codehaus.cargo.container.resin.Resin3xInstalledLocalContainer");
        this.registerContainer("tomcat3x", ContainerType.INSTALLED, "org.codehaus.cargo.container.tomcat.Tomcat3xInstalledLocalContainer");
        this.registerContainer("tomcat4x", ContainerType.INSTALLED, "org.codehaus.cargo.container.tomcat.Tomcat4xInstalledLocalContainer");
        this.registerContainer("tomcat4x", ContainerType.REMOTE, "org.codehaus.cargo.container.tomcat.Tomcat4xRemoteContainer");
        this.registerContainer("tomcat5x", ContainerType.INSTALLED, "org.codehaus.cargo.container.tomcat.Tomcat5xInstalledLocalContainer");
        this.registerContainer("tomcat5x", ContainerType.REMOTE, "org.codehaus.cargo.container.tomcat.Tomcat5xRemoteContainer");
        this.registerContainer("tomcat5x", ContainerType.EMBEDDED, "org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalContainer");
        this.registerContainer("tomcat6x", ContainerType.INSTALLED, "org.codehaus.cargo.container.tomcat.Tomcat6xInstalledLocalContainer");
        this.registerContainer("tomcat6x", ContainerType.REMOTE, "org.codehaus.cargo.container.tomcat.Tomcat6xRemoteContainer");
        this.registerContainer("tomcat6x", ContainerType.EMBEDDED, "org.codehaus.cargo.container.tomcat.Tomcat6xEmbeddedLocalContainer");
        this.registerContainer("tomcat7x", ContainerType.INSTALLED, "org.codehaus.cargo.container.tomcat.Tomcat7xInstalledLocalContainer");
        this.registerContainer("tomcat7x", ContainerType.REMOTE, "org.codehaus.cargo.container.tomcat.Tomcat7xRemoteContainer");
        this.registerContainer("tomcat7x", ContainerType.EMBEDDED, "org.codehaus.cargo.container.tomcat.Tomcat7xEmbeddedLocalContainer");
        this.registerContainer("weblogic8x", ContainerType.INSTALLED, "org.codehaus.cargo.container.weblogic.WebLogic8xInstalledLocalContainer");
        this.registerContainer("weblogic9x", ContainerType.INSTALLED, "org.codehaus.cargo.container.weblogic.WebLogic9xInstalledLocalContainer");
        this.registerContainer("weblogic10x", ContainerType.INSTALLED, "org.codehaus.cargo.container.weblogic.WebLogic10xInstalledLocalContainer");
    }

    public boolean isContainerRegistered(String containerId, ContainerType containerType) {
        return this.hasMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()));
    }

    public void registerContainer(String containerId, ContainerType containerType, Class containerClass) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()), containerClass);
    }

    public void registerContainer(String containerId, ContainerType containerType, String containerClassName) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()), containerClassName);
    }

    public Class getContainerClass(String containerId, ContainerType containerType) {
        return this.getMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()));
    }

    public Container createContainer(String containerId, ContainerType containerType, Configuration configuration) {
        ContainerFactoryParameters parameters = new ContainerFactoryParameters();
        parameters.configuration = configuration;
        return (Container)this.createImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), containerType.getType()), parameters, "container");
    }

    protected Constructor getConstructor(Class containerClass, String containerType, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        Constructor constructor;
        ContainerType type = ContainerType.toType(containerType);
        if (type.isLocal()) {
            constructor = containerClass.getConstructor(LocalConfiguration.class);
        } else if (type.isRemote()) {
            constructor = containerClass.getConstructor(RuntimeConfiguration.class);
        } else {
            throw new ContainerException("Unknown container type [" + type.getType() + "]");
        }
        return constructor;
    }

    protected Object createInstance(Constructor constructor, String containerType, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        Configuration configuration = ((ContainerFactoryParameters)parameters).configuration;
        return constructor.newInstance(configuration);
    }

    public Map getContainerIds() {
        HashMap containerIds = new HashMap();
        for (RegistrationKey key : this.getMappings().keySet()) {
            Set<ContainerType> hints;
            SimpleContainerIdentity identity = (SimpleContainerIdentity)key.getContainerIdentity();
            if (containerIds.containsKey(identity.getId())) {
                hints = (Set)containerIds.get(identity.getId());
                hints.add(ContainerType.toType(key.getHint()));
                continue;
            }
            hints = new HashSet<ContainerType>();
            hints.add(ContainerType.toType(key.getHint()));
            containerIds.put(identity.getId(), hints);
        }
        return containerIds;
    }

    private static class ContainerFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public Configuration configuration;

        private ContainerFactoryParameters() {
        }
    }
}

