/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic.internal;

import java.io.File;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.J2EEContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;

public abstract class AbstractWebLogicInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    private String beaHome;
    private ContainerCapability capability = new J2EEContainerCapability();

    public AbstractWebLogicInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public final void setBeaHome(String beaHome) {
        this.beaHome = beaHome;
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public final void initBeaHome() {
        if (!new File(this.getHome()).isDirectory()) {
            throw new ContainerException("[" + this.getHome() + "] is not a directory");
        }
        if (this.beaHome == null) {
            this.beaHome = this.getFileHandler().getParent(this.getHome());
        }
    }

    protected void addToClassPath(Path classpath) {
    }

    public final void doStart(Java java) throws Exception {
        this.initBeaHome();
        java.setDir(new File(this.getConfiguration().getHome()));
        File serverDir = new File(this.getHome(), "server");
        java.addSysproperty(this.getAntUtils().createSysProperty("weblogic.name", this.getConfiguration().getPropertyValue("cargo.weblogic.server")));
        java.addSysproperty(this.getAntUtils().createSysProperty("bea.home", this.beaHome));
        java.addSysproperty(this.getAntUtils().createSysProperty("weblogic.management.username", this.getConfiguration().getPropertyValue("cargo.weblogic.administrator.user")));
        java.addSysproperty(this.getAntUtils().createSysProperty("weblogic.management.password", this.getConfiguration().getPropertyValue("cargo.weblogic.administrator.password")));
        java.addSysproperty(this.getAntUtils().createSysProperty("java.security.policy", "=./server/lib/weblogic.policy"));
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic_sp.jar"));
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic.jar"));
        classpath.createPathElement().setLocation(new File(this.getConfiguration().getHome()));
        this.addToClassPath(classpath);
        this.addToolsJarToClasspath(classpath);
        java.setClassname("weblogic.Server");
        AntContainerExecutorThread webLogicRunner = new AntContainerExecutorThread(java);
        webLogicRunner.start();
    }

    public void doStop(Java java) throws Exception {
        File serverDir = new File(this.getHome(), "server");
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic_sp.jar"));
        classpath.createPathElement().setLocation(new File(serverDir, "lib/weblogic.jar"));
        this.addToClassPath(classpath);
        java.setClassname("weblogic.Admin");
        java.createArg().setValue("-url");
        java.createArg().setValue("t3://localhost:" + this.getConfiguration().getPropertyValue("cargo.servlet.port"));
        java.createArg().setValue("-username");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.weblogic.administrator.user"));
        java.createArg().setValue("-password");
        java.createArg().setValue(this.getConfiguration().getPropertyValue("cargo.weblogic.administrator.password"));
        java.createArg().setValue("FORCESHUTDOWN");
        AntContainerExecutorThread webLogicRunner = new AntContainerExecutorThread(java);
        webLogicRunner.start();
    }
}

