/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.File;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;
import org.codehaus.cargo.container.weblogic.internal.WebLogicExistingLocalConfigurationCapability;

public class WebLogicExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    private static ConfigurationCapability capability = new WebLogicExistingLocalConfigurationCapability();

    public WebLogicExistingLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.weblogic.administrator.user", "weblogic");
        this.setProperty("cargo.weblogic.administrator.password", "weblogic");
        this.setProperty("cargo.weblogic.server", "server");
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupDeployables(container);
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    public String toString() {
        return "WebLogic Existing Configuration";
    }

    protected void setupDeployables(Container container) {
        try {
            FileUtils fileUtils = FileUtils.newFileUtils();
            String appDir = this.getFileHandler().createDirectory(this.getHome(), "applications");
            for (Deployable deployable : this.getDeployables()) {
                if (deployable.getType() == DeployableType.WAR && ((WAR)deployable).isExpandedWar()) continue;
                fileUtils.copyFile(deployable.getFile(), this.getFileHandler().append(appDir, this.getFileHandler().getName(deployable.getFile())), null, true);
            }
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to deploy Deployables in the " + container.getName() + " [" + this.getHome() + "] domain directory", e);
        }
    }
}

