/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.weblogic;

import java.io.File;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.container.weblogic.internal.WebLogicStandaloneLocalConfigurationCapability;

public class WebLogic10xStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new WebLogicStandaloneLocalConfigurationCapability();

    public WebLogic10xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.weblogic.administrator.user", "weblogic");
        this.setProperty("cargo.weblogic.administrator.password", "weblogic");
        this.setProperty("cargo.weblogic.server", "server");
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        FilterChain filterChain = this.createWebLogicFilterChain();
        String[] resources = new String[]{"autodeploy/readme.txt", "servers/AdminServer/security/boot.properties", "security/XACMLRoleMapperInit.ldift", "security/SerializedSystemIni.dat", "security/DefaultRoleMapperInit.ldift", "security/DefaultAuthenticatorInit.ldift", "lib/readme.txt", "init-info/tokenValue.properties", "init-info/startscript.xml", "init-info/security.xml", "init-info/domain-info.xml", "console-ext/readme.txt", "config/config.xml", "config/startup/readme.txt", "config/security/readme.txt", "config/nodemanager/nm_password.properties", "config/lib/readme.txt", "config/jms/readme.txt", "config/jdbc/readme.txt", "config/diagnostics/readme.txt", "config/deployments/readme.txt", "autodeploy/readme.txt", "fileRealm.properties"};
        for (int i = 0; i < resources.length; ++i) {
            this.copyResource(container.getId(), resources[i], filterChain);
        }
        this.setupDeployables(container);
    }

    private void copyResource(String containerId, String resourceName, FilterChain filterChain) throws Exception {
        File destFile = new File(this.getHome(), resourceName);
        destFile.getParentFile().mkdirs();
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + containerId + "/" + resourceName, destFile, filterChain);
    }

    private FilterChain createWebLogicFilterChain() {
        FilterChain filterChain = this.createFilterChain();
        StringBuffer appTokenValue = new StringBuffer(" ");
        for (Deployable deployable : this.getDeployables()) {
            if (deployable.getType() != DeployableType.WAR || !((WAR)deployable).isExpandedWar()) continue;
            String context = ((WAR)deployable).getContext();
            appTokenValue.append("<Application ");
            appTokenValue.append("Name=\"_" + context + "_app\" ");
            appTokenValue.append("Path=\"" + this.getFileHandler().getParent(deployable.getFile()) + "\" ");
            appTokenValue.append("StagedTargets=\"server\" StagingMode=\"stage\" TwoPhase=\"true\"");
            appTokenValue.append(">");
            appTokenValue.append("<WebAppComponent ");
            appTokenValue.append("Name=\"" + context + "\" ");
            appTokenValue.append("Targets=\"server\" ");
            appTokenValue.append("URI=\"" + context + "\"");
            appTokenValue.append("/></Application>");
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "weblogic.apps", appTokenValue.toString());
        return filterChain;
    }

    protected void setupDeployables(Container container) {
        try {
            FileUtils fileUtils = FileUtils.newFileUtils();
            String appDir = this.getFileHandler().createDirectory(this.getHome(), "autodeploy");
            for (Deployable deployable : this.getDeployables()) {
                if (deployable.getType() == DeployableType.WAR && ((WAR)deployable).isExpandedWar()) continue;
                fileUtils.copyFile(deployable.getFile(), this.getFileHandler().append(appDir, this.getFileHandler().getName(deployable.getFile())), null, true);
            }
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to deploy Deployables in the " + container.getName() + " [" + this.getHome() + "] domain directory", e);
        }
    }

    public String toString() {
        return "WebLogic Standalone Configuration";
    }
}

