/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatWAR;
import org.codehaus.cargo.container.tomcat.internal.AbstractTomcatStandaloneLocalConfiguration;

public abstract class AbstractCatalinaStandaloneLocalConfiguration
extends AbstractTomcatStandaloneLocalConfiguration {
    public AbstractCatalinaStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.servlet.users", "admin::manager");
        this.setProperty("cargo.servlet.uriencoding", "ISO-8859-1");
        this.setProperty("cargo.tomcat.context.reloadable", "false");
        this.setProperty("cargo.tomcat.copywars", "true");
        this.setProperty("cargo.tomcat.webappsDirectory", "webapps");
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        FilterChain filterChain = this.createTomcatFilterChain();
        this.getFileHandler().createDirectory(this.getHome(), "temp");
        this.getFileHandler().createDirectory(this.getHome(), "logs");
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/server.xml", new File(confDir, "server.xml"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/tomcat-users.xml", new File(confDir, "tomcat-users.xml"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/web.xml", new File(confDir, "web.xml"));
        this.setupManager(container);
        this.setupWebApps(container);
    }

    protected abstract void setupManager(LocalContainer var1);

    private void setupWebApps(LocalContainer container) {
        try {
            if (container instanceof EmbeddedLocalContainer) {
                Tomcat5xEmbeddedLocalDeployer deployer = new Tomcat5xEmbeddedLocalDeployer((Tomcat5xEmbeddedLocalContainer)container);
                deployer.deploy(this.getDeployables());
            } else {
                String appDir = this.getFileHandler().createDirectory(this.getHome(), "webapps");
                TomcatCopyingInstalledLocalDeployer deployer = new TomcatCopyingInstalledLocalDeployer((InstalledLocalContainer)container);
                deployer.setShouldDeployExpandedWARs(true);
                deployer.setShouldCopyWars(false);
                deployer.deploy(this.getDeployables());
                this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
            }
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + container.getName() + " container configuration", e);
        }
    }

    private String getTomcatLoggingLevel(String cargoLoggingLevel) {
        String level = cargoLoggingLevel.equalsIgnoreCase("low") ? "1" : (cargoLoggingLevel.equalsIgnoreCase("medium") ? "2" : "4");
        return level;
    }

    protected FilterChain createTomcatFilterChain() {
        FilterChain filterChain = this.createFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.logging.level", this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.rmi.port", this.getPropertyValue("cargo.rmi.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.tomcat.ajp.port", this.getPropertyValue("cargo.tomcat.ajp.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.secure", String.valueOf("https".equalsIgnoreCase(this.getPropertyValue("cargo.protocol"))));
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.users", this.getSecurityToken());
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.servlet.uriencoding", this.getPropertyValue("cargo.servlet.uriencoding"));
        StringBuffer webappTokenValue = new StringBuffer(" ");
        for (Deployable deployable : this.getDeployables()) {
            if (deployable.getType() != DeployableType.WAR) {
                throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
            }
            TomcatWAR tomcatWar = new TomcatWAR(deployable.getFile());
            if (tomcatWar.containsContextFile()) continue;
            webappTokenValue.append(this.createContextToken((WAR)deployable));
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.webapps", webappTokenValue.toString());
        String[] jvmarg = this.getPropertyValue("cargo.jvmargs").split("\\s+");
        String catalina_jvmroute = this.getPropertyValue("cargo.hostname");
        int i = 0;
        while (i < jvmarg.length) {
            String[] tokens;
            if (jvmarg[i].indexOf("jvmroute") >= 0 && (tokens = jvmarg[i].split("=")).length == 2) {
                catalina_jvmroute = tokens[1];
            }
            ++i;
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.jvmroute", catalina_jvmroute);
        return filterChain;
    }

    protected abstract String createDatasourceTokenValue();

    protected String createContextToken(WAR deployable) {
        StringBuffer contextTokenValue = new StringBuffer();
        contextTokenValue.append("<Context path=\"");
        contextTokenValue.append("/" + deployable.getContext());
        contextTokenValue.append("\" docBase=\"");
        contextTokenValue.append(new File(deployable.getFile()).getAbsolutePath());
        contextTokenValue.append("\" debug=\"");
        contextTokenValue.append(this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        contextTokenValue.append("\">");
        contextTokenValue.append("\n" + this.createDatasourceTokenValue() + "\n");
        contextTokenValue.append("</Context>");
        return contextTokenValue.toString();
    }

    public String toString() {
        return "Catalina Standalone Configuration";
    }
}

