/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.property.DataSource;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaStandaloneLocalConfiguration;

public class Tomcat5xStandaloneLocalConfiguration
extends AbstractCatalinaStandaloneLocalConfiguration {
    public Tomcat5xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    protected void setupManager(LocalContainer container) {
        if (!(container instanceof EmbeddedLocalContainer)) {
            Copy copy = (Copy)this.getAntUtils().createAntTask("copy");
            FileSet fileSet = new FileSet();
            fileSet.setDir(new File(((InstalledLocalContainer)container).getHome()));
            fileSet.createInclude().setName("conf/Catalina/localhost/manager.xml");
            fileSet.createInclude().setName("server/lib/catalina.jar");
            fileSet.createInclude().setName("server/webapps/manager/**");
            copy.addFileset(fileSet);
            copy.setTodir(new File(this.getHome()));
            copy.execute();
        }
    }

    protected String createDatasourceTokenValue() {
        this.getLogger().debug("Tomcat 5x createDatasourceTokenValue", this.getClass().getName());
        String dataSourceProperty = this.getPropertyValue("cargo.datasource.datasource");
        this.getLogger().debug("Datasource property value [" + dataSourceProperty + "]", this.getClass().getName());
        if (dataSourceProperty == null) {
            return " ";
        }
        DataSource ds = new DataSource(dataSourceProperty);
        return "<Resource name='" + ds.getJndiLocation() + "'\n" + "    auth='Container'\n" + "    type='" + ds.getDataSourceType() + "'\n" + "    username='" + ds.getUsername() + "'\n" + "    password='" + ds.getPassword() + "'\n" + "    driverClassName='" + ds.getDriverClass() + "'\n" + "    url='" + ds.getUrl() + "'\n" + "/>\n" + "<Resource jotm.timeout='60' " + "    factory='org.objectweb.jotm.UserTransactionFactory' " + "    name='UserTransaction' " + "    type='javax.transaction.UserTransaction' " + "    auth='Container'>\n" + "</Resource>";
    }

    public String toString() {
        return "Tomcat 5.x Standalone Configuration";
    }
}

