/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.spi.AbstractEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalDeployer;
import org.codehaus.cargo.container.tomcat.internal.Tomcat5xEmbedded;

public class Tomcat5xEmbeddedLocalContainer
extends AbstractEmbeddedLocalContainer {
    private ContainerCapability capability = new ServletContainerCapability();
    private Tomcat5xEmbedded.Embedded controller;
    private Tomcat5xEmbedded.Host host;
    private final List scheduledDeployables = new ArrayList();

    public Tomcat5xEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    Tomcat5xEmbedded.Embedded getController() {
        return this.controller;
    }

    Tomcat5xEmbedded.Host getHost() {
        return this.host;
    }

    protected void doStart() throws Exception {
        Tomcat5xEmbedded wrapper = new Tomcat5xEmbedded(this.getClassLoader());
        this.controller = wrapper.new Tomcat5xEmbedded.Embedded();
        File home = new File(this.getConfiguration().getHome()).getAbsoluteFile();
        this.controller.setCatalinaBase(home);
        this.controller.setCatalinaHome(new File(this.getConfiguration().getHome()));
        Tomcat5xEmbedded.MemoryRealm realm = wrapper.new Tomcat5xEmbedded.MemoryRealm();
        realm.setPathname(new File(home, "conf/tomcat-users.xml"));
        this.controller.setRealm(realm);
        Tomcat5xEmbedded.Engine engine = this.controller.createEngine();
        engine.setName("engine");
        engine.setBaseDir(home.getPath());
        engine.setParentClassLoader(this.getClassLoader());
        this.host = this.controller.createHost("localhost", new File(home, "webapps"));
        this.host.setAutoDeploy(true);
        engine.addChild(this.host);
        engine.setDefaultHost(this.host.getName());
        this.controller.addEngine(engine);
        this.controller.addConnector(this.controller.createConnector(null, this.getPort(), false));
        this.controller.start();
        if (!this.scheduledDeployables.isEmpty()) {
            Tomcat5xEmbeddedLocalDeployer deployer = new Tomcat5xEmbeddedLocalDeployer(this);
            for (Deployable deployable : this.scheduledDeployables) {
                deployer.deploy(deployable);
            }
        }
    }

    protected void waitForCompletion(boolean waitForStarting) {
    }

    private int getPort() {
        return Integer.parseInt(this.getConfiguration().getPropertyValue("cargo.servlet.port"));
    }

    protected void doStop() throws Exception {
        if (this.controller != null) {
            this.controller.stop();
            this.controller = null;
            this.host = null;
        }
    }

    public String getId() {
        return "tomcat5x";
    }

    public String getName() {
        return "Tomcat 5.x Embedded";
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    void scheduleDeployment(Deployable deployable) {
        this.scheduledDeployables.add(deployable);
    }
}

