/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.File;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.tomcat.internal.AbstractTomcatStandaloneLocalConfiguration;

public class Tomcat3xStandaloneLocalConfiguration
extends AbstractTomcatStandaloneLocalConfiguration {
    public Tomcat3xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        FilterChain filterChain = this.createTomcatFilterChain();
        this.setupConfigurationDir();
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/server.xml", new File(confDir, "server.xml"), filterChain);
        String usersDir = this.getFileHandler().createDirectory(confDir, "users");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/tomcat-users.xml", new File(usersDir, "tomcat-users.xml"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/modules.xml", new File(confDir, "modules.xml"));
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/apps.xml", new File(confDir, "apps.xml"), filterChain);
        this.setupWebApps(container);
    }

    private void setupWebApps(Container container) {
        try {
            FileUtils fileUtils = FileUtils.newFileUtils();
            String appDir = this.getFileHandler().createDirectory(this.getHome(), "webapps");
            for (Deployable deployable : this.getDeployables()) {
                if (deployable.getType() == DeployableType.WAR && !((WAR)deployable).isExpandedWar()) {
                    String appName = this.getFileHandler().getName(deployable.getFile());
                    fileUtils.copyFile(new File(deployable.getFile()).getAbsolutePath(), this.getFileHandler().append(appDir, appName), null, true);
                    continue;
                }
                if (deployable.getType() == DeployableType.WAR) continue;
                throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
            }
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + container.getName() + " container configuration", e);
        }
    }

    private FilterChain createTomcatFilterChain() {
        FilterChain filterChain = this.createFilterChain();
        String logEventsEnabled = "false";
        String logLevel = this.getPropertyValue("cargo.logging");
        if (logLevel.equalsIgnoreCase("error")) {
            logEventsEnabled = "true";
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat3x.logEvents.enabled", logEventsEnabled);
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat3x.logging.level", this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.users", this.getSecurityToken());
        StringBuffer webappTokenValue = new StringBuffer(" ");
        for (WAR deployable : this.getDeployables()) {
            if (!deployable.isExpandedWar()) continue;
            webappTokenValue.append("<Context path=\"");
            webappTokenValue.append("/" + deployable.getContext());
            webappTokenValue.append("\" docBase=\"");
            webappTokenValue.append(deployable.getFile());
            webappTokenValue.append("\" debug=\"");
            webappTokenValue.append(this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
            webappTokenValue.append("\"/>");
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.webapps", webappTokenValue.toString());
        return filterChain;
    }

    private String getTomcatLoggingLevel(String cargoLoggingLevel) {
        String level = cargoLoggingLevel.equalsIgnoreCase("low") ? "FATAL" : (cargoLoggingLevel.equalsIgnoreCase("medium") ? "WARNING" : "DEBUG");
        return level;
    }

    public String toString() {
        return "Tomcat 3.x Standalone Configuration";
    }
}

