/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.jvm;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;
import org.codehaus.cargo.container.spi.jvm.JvmLauncherException;

class DefaultJvmLauncher
implements JvmLauncher {
    private final Java java;

    public DefaultJvmLauncher(Java java) {
        this.java = java;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.java.setDir(workingDirectory);
    }

    public void setJvm(String command) {
        this.java.setJvm(command);
    }

    public void addJvmArgument(File file) {
        if (file != null) {
            this.java.createJvmarg().setFile(file);
        }
    }

    public void addJvmArguments(String ... values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.java.createJvmarg().setValue(value);
                ++n2;
            }
        }
    }

    public void addJvmArgumentLine(String line) {
        if (line != null) {
            this.java.createJvmarg().setLine(line);
        }
    }

    public void addClasspathEntries(String ... paths) {
        if (paths != null) {
            Path cp = this.java.createClasspath();
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                cp.createPathElement().setPath(path);
                ++n2;
            }
        }
    }

    public void addClasspathEntries(File ... paths) {
        if (paths != null) {
            Path cp = this.java.createClasspath();
            File[] fileArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                File path = fileArray[n2];
                cp.createPathElement().setLocation(path);
                ++n2;
            }
        }
    }

    public String getClasspath() {
        Path p = this.java.getCommandLine().getClasspath();
        return p != null ? p.toString() : "";
    }

    public void setSystemProperty(String name, String value) {
        if (name != null && name.length() > 0) {
            Environment.Variable var = new Environment.Variable();
            var.setKey(name);
            var.setValue(value != null ? value : "");
            this.java.addSysproperty(var);
        }
    }

    public void setJarFile(File jarFile) {
        if (jarFile != null) {
            this.java.setJar(jarFile);
        }
    }

    public void setMainClass(String mainClass) {
        if (mainClass != null) {
            this.java.setClassname(mainClass);
        }
    }

    public void addAppArgument(File file) {
        if (file != null) {
            this.java.createArg().setFile(file);
        }
    }

    public void addAppArguments(String ... values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.java.createArg().setValue(value);
                ++n2;
            }
        }
    }

    public void addAppArgumentLine(String line) {
        if (line != null) {
            this.java.createArg().setLine(line);
        }
    }

    public void setOutputFile(File outputFile) {
        this.java.setOutput(outputFile);
    }

    public void setAppendOutput(boolean appendOutput) {
        this.java.setAppend(appendOutput);
    }

    public String getCommandLine() {
        return this.java.getCommandLine().toString();
    }

    public void setTimeout(long millis) {
        if (millis > 0L) {
            this.java.setTimeout(Long.valueOf(millis));
        } else {
            this.java.setTimeout(null);
        }
    }

    public void start() throws JvmLauncherException {
        AntContainerExecutorThread catalinaRunner = new AntContainerExecutorThread(this.java);
        catalinaRunner.start();
    }

    public int execute() throws JvmLauncherException {
        try {
            return this.java.executeJava();
        }
        catch (BuildException e) {
            throw new JvmLauncherException(e.getMessage(), e);
        }
    }
}

