/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.jboss.JBoss51xInstalledLocalContainer;
import org.codehaus.cargo.container.jboss.JBossInstalledLocalDeployer;
import org.codehaus.cargo.container.jboss.JBossStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jboss.internal.JBoss5xInstalledLocalContainer;

public class JBoss51xStandaloneLocalConfiguration
extends JBossStandaloneLocalConfiguration {
    public JBoss51xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    protected FilterChain createJBossFilterChain(JBoss51xInstalledLocalContainer container) throws MalformedURLException {
        String httpPort;
        FilterChain filterChain = super.createJBossFilterChain(container);
        File deployersDir = new File(container.getDeployersDir(this.getPropertyValue("cargo.jboss.configuration")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.deployers.url", deployersDir.toURL().toString());
        File deployDir = new File(container.getDeployDir(this.getPropertyValue("cargo.jboss.configuration")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.deploy.url", deployDir.toURL().toString());
        String ajpPort = this.getPropertyValue("cargo.jboss.ajp.connector.port");
        if (ajpPort == null) {
            ajpPort = "8009";
        }
        if ((httpPort = this.getPropertyValue("cargo.jboss.http.connector.port")) == null) {
            httpPort = "8443";
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.ajp.connector.port", ajpPort);
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jboss.http.connector.port", httpPort);
        return filterChain;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.getLogger().info("Configuring JBoss using the [" + this.getPropertyValue("cargo.jboss.configuration") + "] server configuration", this.getClass().getName());
        this.setupConfigurationDir();
        this.jbossContainer = (JBoss51xInstalledLocalContainer)container;
        FilterChain filterChain = this.createJBossFilterChain((JBoss51xInstalledLocalContainer)this.jbossContainer);
        JBossInstalledLocalDeployer deployer = new JBossInstalledLocalDeployer(this.jbossContainer);
        deployer.deploy(this.getDeployables());
        if (container instanceof InstalledLocalContainer) {
            InstalledLocalContainer installedContainer = (InstalledLocalContainer)container;
            String[] sharedClassPath = installedContainer.getSharedClasspath();
            StringBuffer tmp = new StringBuffer();
            if (sharedClassPath != null) {
                for (int i = 0; i < sharedClassPath.length; ++i) {
                    String fileName = this.getFileHandler().getName(sharedClassPath[i]);
                    String directoryName = this.getFileHandler().getParent(sharedClassPath[i]);
                    tmp.append("<classpath codebase=\"" + directoryName + "\" archives=\"" + fileName + "\"/>");
                    tmp.append("\n");
                }
            }
            String sharedClassPathString = tmp.toString();
            this.getLogger().debug("Shared loader classpath is " + sharedClassPathString, this.getClass().getName());
            this.getAntUtils().addTokenToFilterChain(filterChain, "jboss.shared.classpath", tmp.toString());
        }
        String deployDir = this.getFileHandler().createDirectory(this.getHome(), "/deploy");
        String deployersDir = this.getFileHandler().createDirectory(this.getHome(), "/deployers");
        String libDir = this.getFileHandler().createDirectory(this.getHome(), "/lib");
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "/conf");
        String clustered = this.jbossContainer.getConfiguration().getPropertyValue("cargo.jboss.clustered");
        if (Boolean.valueOf(this.jbossContainer.getConfiguration().getPropertyValue("cargo.jboss.clustered")).booleanValue()) {
            String farmDir = this.getFileHandler().createDirectory(this.getHome(), "/farm");
        }
        String[] configFiles = new String[]{"jboss-service.xml"};
        String[] cargoConfigFiles = new String[]{"jboss-service.xml"};
        for (int i = 0; i < cargoConfigFiles.length; ++i) {
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.jbossContainer.getId() + "/" + cargoConfigFiles[i], new File(confDir, cargoConfigFiles[i]), filterChain);
        }
        this.copyExternalResources(new File(this.jbossContainer.getConfDir(this.getPropertyValue("cargo.jboss.configuration"))), new File(confDir), configFiles);
        this.copyExternalResources(new File(this.jbossContainer.getDeployDir(this.getPropertyValue("cargo.jboss.configuration"))), new File(deployDir), new String[0]);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.jbossContainer.getId() + "/" + "server.xml", new File(deployDir + "/jbossweb.sar/", "server.xml"), filterChain);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + this.jbossContainer.getId() + "/" + "bindings-jboss-beans.xml", new File(confDir + "/bindingservice.beans/META-INF", "bindings-jboss-beans.xml"), filterChain);
        this.copyExternalResources(new File(((JBoss5xInstalledLocalContainer)this.jbossContainer).getDeployersDir(this.getPropertyValue("cargo.jboss.configuration"))), new File(deployersDir), new String[0]);
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(this.getHome(), "/deploy/cargocpc.war"));
    }
}

