/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.terracotta.statistics.StatisticType;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.ValueStatistics;

public abstract class TableSkeleton
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, ValueStatistic<? extends Serializable>[]> statistics = new LinkedHashMap<String, ValueStatistic<? extends Serializable>[]>();
    private final String[] innerStatisticNames;

    protected TableSkeleton(String ... innerStatisticNames) {
        this.innerStatisticNames = (String[])innerStatisticNames.clone();
        Arrays.sort(this.innerStatisticNames);
    }

    public boolean isEmpty() {
        return this.statistics.isEmpty();
    }

    public int getRowCount() {
        return this.statistics.size();
    }

    public Collection<String> getRowLabels() {
        return this.statistics.keySet();
    }

    public String[] getStatisticNames() {
        return (String[])this.innerStatisticNames.clone();
    }

    public int getStatisticCount() {
        return this.innerStatisticNames.length;
    }

    public ValueStatistic<? extends Serializable>[] getStatistics(String row) {
        return this.statistics.get(row);
    }

    public Map<String, ValueStatistic<? extends Serializable>[]> getStatistics() {
        return this.statistics;
    }

    public <T extends Serializable> Optional<ValueStatistic<T>> getStatistic(String row, String statisticName) {
        ValueStatistic<? extends Serializable>[] statistics = this.statistics.get(row);
        if (statistics == null) {
            return Optional.empty();
        }
        int idx = Arrays.binarySearch(this.innerStatisticNames, statisticName);
        if (idx < 0) {
            return Optional.empty();
        }
        return Optional.of(statistics[idx]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{statistics=" + this.statistics + ", rowCount=" + this.getRowCount() + ", rowLabels=" + this.getRowLabels() + '}';
    }

    protected <T extends Serializable> void insert(String rowName, String statisticName, StatisticType type, T value) {
        this.insert(rowName, statisticName, ValueStatistics.constant(type, value));
    }

    protected <T extends Serializable> void insert(String rowName, String statisticName, ValueStatistic<T> accessor) {
        int idx = Arrays.binarySearch(this.innerStatisticNames, statisticName);
        if (idx < 0) {
            throw new IllegalArgumentException("Illegal inner statistic: " + statisticName + ". Allowed: " + Arrays.asList(this.innerStatisticNames));
        }
        ValueStatistic<? extends Serializable>[] accessors = this.statistics.get(rowName);
        if (accessors == null) {
            accessors = new ValueStatistic[this.innerStatisticNames.length];
            this.statistics.put(rowName, accessors);
        }
        accessors[idx] = accessor;
    }
}

