/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.derived;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.observer.ChainedEventObserver;
import org.terracotta.statistics.util.InThreadExecutor;

public class MinMaxAverage
implements ChainedEventObserver {
    private final LongAccumulator maximum = new LongAccumulator(Math::max, Long.MIN_VALUE);
    private final LongAccumulator minimum = new LongAccumulator(Math::min, Long.MAX_VALUE);
    private final DoubleAdder summation = new DoubleAdder();
    private final AtomicLong count = new AtomicLong(0L);
    private final Executor executor;

    public MinMaxAverage() {
        this(InThreadExecutor.INSTANCE);
    }

    public MinMaxAverage(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void event(long time, long ... parameters) {
        this.executor.execute(() -> {
            long value = parameters[0];
            this.maximum.accumulate(value);
            this.minimum.accumulate(value);
            this.summation.add(value);
            this.count.incrementAndGet();
        });
    }

    public Long min() {
        if (this.count.get() == 0L) {
            return null;
        }
        return this.minimum.get();
    }

    public ValueStatistic<Long> minStatistic() {
        return this::min;
    }

    public Double mean() {
        if (this.count.get() == 0L) {
            return null;
        }
        return this.summation.sum() / (double)this.count.get();
    }

    public ValueStatistic<Double> meanStatistic() {
        return this::mean;
    }

    public Long max() {
        if (this.count.get() == 0L) {
            return null;
        }
        return this.maximum.get();
    }

    public ValueStatistic<Long> maxStatistic() {
        return this::max;
    }
}

