/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.context.extended;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.terracotta.context.query.Matcher;
import org.terracotta.context.query.Matchers;

public final class ExtendedMatchers {
    private ExtendedMatchers() {
    }

    public static Matcher<Map<String, Object>> hasTag(final String tag) {
        return Matchers.hasAttribute("tags", (Matcher<? extends Object>)new Matcher<Set<String>>(){

            @Override
            protected boolean matchesSafely(Set<String> object) {
                return object.contains(tag);
            }
        });
    }

    public static Matcher<Map<String, Object>> hasTags(String ... tags) {
        return ExtendedMatchers.hasTags(Arrays.asList(tags));
    }

    public static Matcher<Map<String, Object>> hasTags(final Collection<String> tags) {
        return Matchers.hasAttribute("tags", (Matcher<? extends Object>)new Matcher<Set<String>>(){

            @Override
            protected boolean matchesSafely(Set<String> object) {
                return object.containsAll(tags);
            }
        });
    }

    public static Matcher<Map<String, Object>> hasProperty(final String key) {
        return Matchers.hasAttribute("properties", (Matcher<? extends Object>)new Matcher<Map<String, Object>>(){

            @Override
            protected boolean matchesSafely(Map<String, Object> properties) {
                return properties.containsKey(key);
            }
        });
    }

    public static Matcher<Map<String, Object>> hasProperty(final String key, final String value) {
        return Matchers.hasAttribute("properties", (Matcher<? extends Object>)new Matcher<Map<String, Object>>(){

            @Override
            protected boolean matchesSafely(Map<String, Object> properties) {
                Object val = properties.get(key);
                return val == null ? false : value.equals(val);
            }
        });
    }
}

