/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.context.extended;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.terracotta.context.ContextManager;
import org.terracotta.context.TreeNode;
import org.terracotta.context.extended.OperationStatisticDescriptor;
import org.terracotta.context.extended.RegisteredCompoundStatistic;
import org.terracotta.context.extended.RegisteredRatioStatistic;
import org.terracotta.context.extended.RegisteredStatistic;
import org.terracotta.context.extended.RegisteredValueStatistic;
import org.terracotta.context.extended.ValueStatisticDescriptor;
import org.terracotta.context.query.Matcher;
import org.terracotta.context.query.Matchers;
import org.terracotta.context.query.QueryBuilder;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.Time;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.extended.CompoundOperation;
import org.terracotta.statistics.extended.CompoundOperationImpl;
import org.terracotta.statistics.extended.ExpiringSampledStatistic;

public class StatisticsRegistry {
    private final Object contextObject;
    private final Map<String, RegisteredStatistic> registrations = new ConcurrentHashMap<String, RegisteredStatistic>();
    private final ScheduledExecutorService executor;
    private final Runnable disableTask;
    private volatile long timeToDisable;
    private volatile TimeUnit timeToDisableUnit;
    private volatile ScheduledFuture<?> disableStatus;
    private final long averageWindowDuration;
    private final TimeUnit averageWindowUnit;
    private final int historySize;
    private final long historyInterval;
    private final TimeUnit historyIntervalUnit;

    public StatisticsRegistry(Object contextObject, ScheduledExecutorService executor, long averageWindowDuration, TimeUnit averageWindowUnit, int historySize, long historyInterval, TimeUnit historyIntervalUnit, long timeToDisable, TimeUnit timeToDisableUnit) {
        this.contextObject = contextObject;
        this.averageWindowDuration = averageWindowDuration;
        this.averageWindowUnit = averageWindowUnit;
        this.historySize = historySize;
        this.historyInterval = historyInterval;
        this.historyIntervalUnit = historyIntervalUnit;
        this.executor = executor;
        this.timeToDisable = timeToDisable;
        this.timeToDisableUnit = timeToDisableUnit;
        this.disableTask = this.createDisableTask();
        this.disableStatus = this.executor.scheduleAtFixedRate(this.disableTask, timeToDisable, timeToDisable, timeToDisableUnit);
    }

    private Runnable createDisableTask() {
        return new Runnable(){

            @Override
            public void run() {
                long expireThreshold = Time.absoluteTime() - StatisticsRegistry.this.timeToDisableUnit.toMillis(StatisticsRegistry.this.timeToDisable);
                for (RegisteredStatistic registeredStatistic : StatisticsRegistry.this.registrations.values()) {
                    registeredStatistic.getSupport().expire(expireThreshold);
                }
            }
        };
    }

    public synchronized void setTimeToDisable(long time, TimeUnit unit) {
        this.timeToDisable = time;
        this.timeToDisableUnit = unit;
        if (this.disableStatus != null) {
            this.disableStatus.cancel(false);
            this.disableStatus = this.executor.scheduleAtFixedRate(this.disableTask, this.timeToDisable, this.timeToDisable, this.timeToDisableUnit);
        }
    }

    public synchronized void setAlwaysOn(boolean enabled) {
        if (enabled) {
            if (this.disableStatus != null) {
                this.disableStatus.cancel(false);
                this.disableStatus = null;
            }
            for (RegisteredStatistic registeredStatistic : this.registrations.values()) {
                registeredStatistic.getSupport().setAlwaysOn(true);
            }
        } else {
            if (this.disableStatus == null) {
                this.disableStatus = this.executor.scheduleAtFixedRate(this.disableTask, 0L, this.timeToDisable, this.timeToDisableUnit);
            }
            for (RegisteredStatistic registeredStatistic : this.registrations.values()) {
                registeredStatistic.getSupport().setAlwaysOn(false);
            }
        }
    }

    public void registerValue(String name, ValueStatisticDescriptor descriptor) {
        HashMap<String, RegisteredValueStatistic> registeredStatistics = new HashMap<String, RegisteredValueStatistic>();
        Map<String, ValueStatistic<?>> valueStatistics = StatisticsRegistry.findValueStatistics(this.contextObject, name, descriptor.getObserverName(), descriptor.getTags());
        HashSet<String> duplicates = new HashSet<String>();
        for (Map.Entry<String, ValueStatistic<?>> entry : valueStatistics.entrySet()) {
            String key = entry.getKey();
            ValueStatistic<?> value = entry.getValue();
            if (this.registrations.containsKey(key)) {
                duplicates.add(key);
            }
            ExpiringSampledStatistic expiringSampledStatistic = new ExpiringSampledStatistic(value, this.executor, this.historySize, this.historyInterval, this.historyIntervalUnit);
            registeredStatistics.put(key, new RegisteredValueStatistic(expiringSampledStatistic));
        }
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Found duplicate value statistic(s) " + duplicates);
        }
        this.registrations.putAll(registeredStatistics);
    }

    public void registerCompoundOperations(String name, OperationStatisticDescriptor descriptor, EnumSet<?> compound) {
        Map<String, CompoundOperation<?>> compoundOperations = this.createCompoundOperations(name, descriptor.getObserverName(), descriptor.getTags(), descriptor.getType());
        HashMap<String, RegisteredCompoundStatistic> registeredStatistics = new HashMap<String, RegisteredCompoundStatistic>();
        HashSet<String> duplicates = new HashSet<String>();
        for (Map.Entry<String, CompoundOperation<?>> entry : compoundOperations.entrySet()) {
            String key = entry.getKey();
            if (this.registrations.containsKey(key)) {
                duplicates.add(key);
            }
            registeredStatistics.put(key, new RegisteredCompoundStatistic(entry.getValue(), compound));
        }
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Found duplicate operation statistic(s) " + duplicates);
        }
        for (CompoundOperation compoundOperation : compoundOperations.values()) {
            compoundOperation.compound(compound);
        }
        this.registrations.putAll(registeredStatistics);
    }

    public void registerRatios(String name, OperationStatisticDescriptor descriptor, EnumSet<?> ratioNumerator, EnumSet<?> ratioDenominator) {
        Map<String, CompoundOperation<?>> compoundOperations = this.createCompoundOperations(name, descriptor.getObserverName(), descriptor.getTags(), descriptor.getType());
        HashMap<String, RegisteredRatioStatistic> registeredStatistics = new HashMap<String, RegisteredRatioStatistic>();
        HashSet<String> duplicates = new HashSet<String>();
        for (Map.Entry<String, CompoundOperation<?>> entry : compoundOperations.entrySet()) {
            String key = entry.getKey();
            if (this.registrations.containsKey(key)) {
                duplicates.add(key);
            }
            registeredStatistics.put(key, new RegisteredRatioStatistic(entry.getValue(), ratioNumerator, ratioDenominator));
        }
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Found duplicate operation statistic(s) " + duplicates);
        }
        for (CompoundOperation compoundOperation : compoundOperations.values()) {
            compoundOperation.ratioOf(ratioNumerator, ratioDenominator);
        }
        this.registrations.putAll(registeredStatistics);
    }

    public Map<String, RegisteredStatistic> getRegistrations() {
        return Collections.unmodifiableMap(this.registrations);
    }

    public void clearRegistrations() {
        this.registrations.clear();
    }

    private Map<String, CompoundOperation<?>> createCompoundOperations(String name, String observerName, Set<String> tags, Class<? extends Enum<?>> type) {
        HashMap result = new HashMap();
        Map<String, OperationStatistic<?>> operationObservers = StatisticsRegistry.findOperationStatistics(this.contextObject, name, type, observerName, tags);
        if (operationObservers.isEmpty()) {
            throw new IllegalArgumentException("Required statistic observer '" + observerName + "' with tags " + tags + " and type '" + type + "' not found under '" + this.contextObject + "'");
        }
        for (Map.Entry<String, OperationStatistic<?>> entry : operationObservers.entrySet()) {
            CompoundOperationImpl newOperation = new CompoundOperationImpl(entry.getValue(), type, this.averageWindowDuration, this.averageWindowUnit, this.executor, this.historySize, this.historyInterval, this.historyIntervalUnit);
            result.put(entry.getKey(), newOperation);
        }
        return result;
    }

    private static Map<String, OperationStatistic<?>> findOperationStatistics(Object contextObject, String name, Class<? extends Enum<?>> type, String observerName, final Set<String> tags) {
        Set<TreeNode> result = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("type", type), Matchers.hasAttribute("name", observerName), Matchers.hasAttribute("tags", (Matcher<? extends Object>)new Matcher<Set<String>>(){

            @Override
            protected boolean matchesSafely(Set<String> object) {
                return object.containsAll(tags);
            }
        }))))).filter(Matchers.context(Matchers.identifier(Matchers.subclassOf(OperationStatistic.class)))).build().execute(Collections.singleton(ContextManager.nodeFor(contextObject)));
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap observers = new HashMap();
        for (TreeNode node : result) {
            String completeName;
            OperationStatistic existing;
            String discriminator = null;
            Map properties = (Map)node.getContext().attributes().get("properties");
            if (properties != null && properties.containsKey("discriminator")) {
                discriminator = properties.get("discriminator").toString();
            }
            if ((existing = observers.put(completeName = (discriminator == null ? "" : discriminator + ":") + name, (OperationStatistic)node.getContext().attributes().get("this"))) == null) continue;
            throw new IllegalStateException("Duplicate OperationStatistic found for '" + completeName + "'");
        }
        return observers;
    }

    private static Map<String, ValueStatistic<?>> findValueStatistics(Object contextObject, String name, String observerName, final Set<String> tags) {
        Set<TreeNode> result = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("name", observerName), Matchers.hasAttribute("tags", (Matcher<? extends Object>)new Matcher<Set<String>>(){

            @Override
            protected boolean matchesSafely(Set<String> object) {
                return object.containsAll(tags);
            }
        }))))).filter(Matchers.context(Matchers.identifier(Matchers.subclassOf(ValueStatistic.class)))).build().execute(Collections.singleton(ContextManager.nodeFor(contextObject)));
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap observers = new HashMap();
        for (TreeNode node : result) {
            String completeName;
            ValueStatistic existing;
            String discriminator = null;
            Map properties = (Map)node.getContext().attributes().get("properties");
            if (properties != null && properties.containsKey("discriminator")) {
                discriminator = properties.get("discriminator").toString();
            }
            if ((existing = observers.put(completeName = (discriminator == null ? "" : discriminator + ":") + name, (ValueStatistic)node.getContext().attributes().get("this"))) == null) continue;
            throw new IllegalStateException("Duplicate ValueStatistic found for '" + completeName + "'");
        }
        return observers;
    }
}

