/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.workmanager;

import commonj.work.Work;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.masterworker.AbstractMaster;
import org.terracotta.masterworker.Master;
import org.terracotta.masterworker.WorkMessage;
import org.terracotta.message.routing.Router;
import org.terracotta.message.topology.Topology;
import org.terracotta.message.topology.TopologyManager;
import org.terracotta.workmanager.support.DefaultWorkItem;

public abstract class AbstractWorkManager
implements WorkManager {
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractWorkManager.class);
    private final Master<DefaultWorkItem> masterDelegate;
    private final List<DefaultWorkItem> completedWorks = new LinkedList<DefaultWorkItem>();

    public AbstractWorkManager(String topologyName, Router router) {
        this(topologyName, null, router);
    }

    public AbstractWorkManager(String topologyName, Topology.Factory topologyFactory, Router router) {
        this.masterDelegate = new MasterDelegate((Topology<WorkMessage<DefaultWorkItem>, String>)TopologyManager.getInstance().getOrCreateTopology(topologyName, topologyFactory), router);
        this.masterDelegate.start();
    }

    public WorkItem schedule(Work work) {
        return this.schedule(work, null);
    }

    public WorkItem schedule(Work work, WorkListener listener) {
        return this.schedule(work, listener, false);
    }

    public WorkItem schedule(Work work, WorkListener listener, boolean cancelWorkStatusTracking) {
        DefaultWorkItem workItem = new DefaultWorkItem(work, listener, cancelWorkStatusTracking);
        return this.schedule(workItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForAll(Collection workItems, long timeout) throws InterruptedException {
        List<DefaultWorkItem> list = this.completedWorks;
        synchronized (list) {
            long startTime = 0L;
            int numberOfCurrentlyCompletedWorks = 0;
            for (long waitingTime = timeout; (numberOfCurrentlyCompletedWorks = this.getCurrentlyCompletedWorksFor(workItems).size()) < workItems.size() && waitingTime > 0L; waitingTime -= System.currentTimeMillis() - startTime) {
                startTime = System.currentTimeMillis();
                logger.info("Waiting for all {} work items with timeout {}", (Object)workItems.size(), (Object)timeout);
                this.completedWorks.wait(waitingTime);
            }
            return numberOfCurrentlyCompletedWorks == workItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection waitForAny(Collection workItems, long timeout) throws InterruptedException {
        List<DefaultWorkItem> list = this.completedWorks;
        synchronized (list) {
            long startTime = 0L;
            List currentlyCompletedWorks = null;
            for (long waitingTime = timeout; (currentlyCompletedWorks = this.getCurrentlyCompletedWorksFor(workItems)).size() == 0 && waitingTime > 0L; waitingTime -= System.currentTimeMillis() - startTime) {
                startTime = System.currentTimeMillis();
                logger.info("Waiting for all {} work items with timeout {}", (Object)workItems.size(), (Object)timeout);
                this.completedWorks.wait(waitingTime);
            }
            return currentlyCompletedWorks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompletedWorks(Collection workItems) {
        List<DefaultWorkItem> list = this.completedWorks;
        synchronized (list) {
            for (Object obj : workItems) {
                WorkItem item = (WorkItem)obj;
                this.completedWorks.remove(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCompletedWorks() {
        List<DefaultWorkItem> list = this.completedWorks;
        synchronized (list) {
            this.completedWorks.clear();
        }
    }

    public final void shutdown() {
        this.masterDelegate.shutdown();
    }

    private List getCurrentlyCompletedWorksFor(Collection workItems) {
        ArrayList<WorkItem> currentlyCompletedWorks = new ArrayList<WorkItem>(workItems.size());
        for (Object obj : workItems) {
            WorkItem item = (WorkItem)obj;
            if (!this.completedWorks.contains(item)) continue;
            currentlyCompletedWorks.add(item);
            logger.debug("Found completed work item: {}", (Object)item);
        }
        return currentlyCompletedWorks;
    }

    private WorkItem schedule(DefaultWorkItem workItem) {
        workItem.setStatus(1, null);
        this.masterDelegate.submit(workItem);
        return workItem;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MasterDelegate
    extends AbstractMaster<DefaultWorkItem> {
        public MasterDelegate(Topology<WorkMessage<DefaultWorkItem>, String> topology, Router router) {
            super(topology, router);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onComplete(WorkMessage<DefaultWorkItem> workMessage) {
            DefaultWorkItem workItem = workMessage.getWorkObject();
            logger.debug("Completed work item {} with state: {}", (Object)workItem, (Object)workItem.getStatus());
            List list = AbstractWorkManager.this.completedWorks;
            synchronized (list) {
                AbstractWorkManager.this.completedWorks.add(workItem);
                AbstractWorkManager.this.completedWorks.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onShutdown() {
            List list = AbstractWorkManager.this.completedWorks;
            synchronized (list) {
                AbstractWorkManager.this.completedWorks.clear();
            }
        }
    }
}

