/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.masterworker.cluster;

import com.tc.cluster.DsoCluster;
import com.tc.cluster.DsoClusterListener;
import com.tc.cluster.DsoClusterTopology;
import com.tc.cluster.exceptions.UnclusteredObjectException;
import com.tcclient.cluster.DsoNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.masterworker.cluster.ClusterStateEvent;
import org.terracotta.masterworker.cluster.ClusterStateListener;
import org.terracotta.modules.concurrent.collections.ConcurrentStringMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterState {
    private static final transient Logger logger = LoggerFactory.getLogger(ClusterState.class);
    private static final Map<String, ClusterState> instances = new HashMap<String, ClusterState>();
    private DsoCluster dsoCluster;
    private final transient List<ClusterStateListener> clusterListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Lock stateLock = new ReentrantLock();
    private final Map<String, List<String>> mastersPerNode = new HashMap<String, List<String>>();
    private final Map<String, List<String>> workersPerNode = new HashMap<String, List<String>>();
    private final Map<String, Lock> locksPerMaster = new ConcurrentStringMap();
    private final Map<String, Map<String, Queue>> submittedPendingWorksPerMaster = new ConcurrentStringMap();
    private final Map<String, Queue> unsubmittedPendingWorksPerMaster = new ConcurrentStringMap();

    private ClusterState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterState getOrCreateInstance(String name) {
        Map<String, ClusterState> map = instances;
        synchronized (map) {
            if (instances.containsKey(name)) {
                return instances.get(name);
            }
            ClusterState created = new ClusterState();
            instances.put(name, created);
            return created;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterState removeInstance(String name) {
        Map<String, ClusterState> map = instances;
        synchronized (map) {
            if (instances.containsKey(name)) {
                return instances.remove(name);
            }
            return null;
        }
    }

    public void registerClusterStateListener(ClusterStateListener listener) {
        this.getDsoCluster().addClusterListener((DsoClusterListener)listener);
        this.clusterListeners.add(listener);
    }

    public void unregisterClusterStateListener(ClusterStateListener listener) {
        this.getDsoCluster().removeClusterListener((DsoClusterListener)listener);
        this.clusterListeners.remove(listener);
    }

    public String getCurrentNodeId() {
        return this.getDsoCluster().getCurrentNode().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMasterForNode(String master, String node) {
        try {
            this.stateLock.lock();
            List<String> masters = this.mastersPerNode.get(node);
            if (masters == null) {
                masters = new LinkedList<String>();
                this.mastersPerNode.put(node, masters);
            }
            masters.add(master);
            this.locksPerMaster.put(master, new ReentrantLock());
            this.submittedPendingWorksPerMaster.put(master, new HashMap());
            this.unsubmittedPendingWorksPerMaster.put(master, new LinkedList());
            logger.info("Added master {} for node {}", (Object)master, (Object)node);
        }
        finally {
            this.stateLock.unlock();
        }
        this.notifyOnMasterAdded(master, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMastersForNode(String node) {
        try {
            this.stateLock.lock();
            ArrayList<String> arrayList = this.mastersPerNode.get(node) != null ? Collections.unmodifiableList(this.mastersPerNode.get(node)) : new ArrayList<String>(0);
            return arrayList;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMasterForNode(String master, String node) {
        block7: {
            try {
                this.stateLock.lock();
                List<String> masters = this.mastersPerNode.get(node);
                if (masters == null) break block7;
                Lock masterLock = this.locksPerMaster.get(master);
                try {
                    masterLock.lock();
                    masters.remove(master);
                    if (masters.isEmpty()) {
                        this.mastersPerNode.remove(node);
                    }
                    this.locksPerMaster.remove(master);
                    this.submittedPendingWorksPerMaster.remove(master);
                    this.unsubmittedPendingWorksPerMaster.remove(master);
                    logger.info("Removed master {} for node {}", (Object)master, (Object)node);
                }
                finally {
                    masterLock.unlock();
                }
            }
            finally {
                this.stateLock.unlock();
            }
        }
        this.notifyOnMasterRemoved(master, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkerForNode(String worker, String node) {
        try {
            this.stateLock.lock();
            List<String> workers = this.workersPerNode.get(node);
            if (workers == null) {
                workers = new LinkedList<String>();
                this.workersPerNode.put(node, workers);
            }
            workers.add(worker);
            logger.info("Added worker {} for node {}", (Object)worker, (Object)node);
        }
        finally {
            this.stateLock.unlock();
        }
        this.notifyOnWorkerAdded(worker, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkerForNode(String worker, String node) {
        try {
            this.stateLock.lock();
            List<String> workers = this.workersPerNode.get(node);
            if (workers != null) {
                workers.remove(worker);
                if (workers.isEmpty()) {
                    this.workersPerNode.remove(node);
                }
            }
            logger.info("Removed worker {} for node {}", (Object)worker, (Object)node);
        }
        finally {
            this.stateLock.unlock();
        }
        this.notifyOnWorkerRemoved(worker, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getWorkersForNode(String node) {
        try {
            this.stateLock.lock();
            LinkedList<String> allWorkers = new LinkedList<String>();
            if (this.workersPerNode.get(node) != null) {
                allWorkers.addAll((Collection)this.workersPerNode.get(node));
            }
            LinkedList<String> linkedList = allWorkers;
            return linkedList;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllWorkers() {
        try {
            this.stateLock.lock();
            HashSet<String> allNodes = new HashSet<String>();
            LinkedList<String> allWorkers = new LinkedList<String>();
            allNodes.addAll(this.workersPerNode.keySet());
            for (String node : allNodes) {
                if (this.workersPerNode.get(node) == null) continue;
                allWorkers.addAll((Collection<String>)this.workersPerNode.get(node));
            }
            LinkedList<String> linkedList = allWorkers;
            return linkedList;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDisconnectedState() {
        try {
            this.stateLock.lock();
            LinkedList<String> connectedNodes = new LinkedList<String>();
            for (DsoNode dsoNode : this.getDsoCluster().getClusterTopology().getNodes()) {
                connectedNodes.add(dsoNode.getId());
            }
            this.clearDisconnectedMasters(connectedNodes);
            this.clearDisconnectedWorkers(connectedNodes);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public Map<String, Queue> acquireSubmittedPendingWorksForMaster(String master) {
        Lock masterLock = this.locksPerMaster.get(master);
        if (masterLock != null) {
            masterLock.lock();
            Map<String, Queue> submittedPendingWorks = this.submittedPendingWorksPerMaster.get(master);
            return submittedPendingWorks;
        }
        throw new IllegalStateException("No master: " + master);
    }

    public Queue acquireUnsubmittedPendingWorksForMaster(String master) {
        Lock masterLock = this.locksPerMaster.get(master);
        if (masterLock != null) {
            masterLock.lock();
            Queue unsubmittedPendingWorks = this.unsubmittedPendingWorksPerMaster.get(master);
            return unsubmittedPendingWorks;
        }
        throw new IllegalStateException("No master: " + master);
    }

    public void releaseSubmittedPendingWorksForMaster(String master) {
        Lock masterLock = this.locksPerMaster.get(master);
        if (masterLock == null) {
            throw new IllegalStateException("No master: " + master);
        }
        masterLock.unlock();
    }

    public void releaseUnsubmittedPendingWorksForMaster(String master) {
        Lock masterLock = this.locksPerMaster.get(master);
        if (masterLock == null) {
            throw new IllegalStateException("No master: " + master);
        }
        masterLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copySubmittedPendingWorksForMasterTo(String master, List destination) {
        Lock masterLock = this.locksPerMaster.get(master);
        if (masterLock != null) {
            try {
                masterLock.lock();
                Map<String, Queue> submittedPendingWorks = this.submittedPendingWorksPerMaster.get(master);
                for (Queue works : submittedPendingWorks.values()) {
                    for (Object work : works) {
                        destination.add(work);
                    }
                }
            }
            finally {
                this.locksPerMaster.get(master).unlock();
            }
        } else {
            throw new IllegalStateException("No master: " + master);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyUnsubmittedPendingWorksForMasterTo(String master, List destination) {
        Lock masterLock = this.locksPerMaster.get(master);
        if (masterLock != null) {
            try {
                masterLock.lock();
                Queue unsubmittedPendingWorks = this.unsubmittedPendingWorksPerMaster.get(master);
                for (Object work : unsubmittedPendingWorks) {
                    destination.add(work);
                }
            }
            finally {
                this.locksPerMaster.get(master).unlock();
            }
        } else {
            throw new IllegalStateException("No master: " + master);
        }
    }

    private DsoCluster getDsoCluster() {
        if (this.dsoCluster != null) {
            return this.dsoCluster;
        }
        return new NoDsoCluster();
    }

    private void clearDisconnectedMasters(Collection<String> connectedNodes) {
        Iterator<String> masterNodesIterator = this.mastersPerNode.keySet().iterator();
        while (masterNodesIterator.hasNext()) {
            String masterNode = masterNodesIterator.next();
            if (connectedNodes.contains(masterNode)) continue;
            masterNodesIterator.remove();
            this.locksPerMaster.remove(masterNode);
            this.submittedPendingWorksPerMaster.remove(masterNode);
            this.unsubmittedPendingWorksPerMaster.remove(masterNode);
        }
    }

    private void clearDisconnectedWorkers(Collection<String> connectedNodes) {
        Iterator<String> workerNodesIterator = this.workersPerNode.keySet().iterator();
        while (workerNodesIterator.hasNext()) {
            String workerNode = workerNodesIterator.next();
            if (connectedNodes.contains(workerNode)) continue;
            workerNodesIterator.remove();
        }
    }

    private void notifyOnMasterAdded(String master, String node) {
        for (ClusterStateListener listener : this.clusterListeners) {
            listener.masteAdded(new ClusterStateEvent(master, null, node));
        }
    }

    private void notifyOnMasterRemoved(String master, String node) {
        for (ClusterStateListener listener : this.clusterListeners) {
            listener.masterRemoved(new ClusterStateEvent(master, null, node));
        }
    }

    private void notifyOnWorkerAdded(String worker, String node) {
        for (ClusterStateListener listener : this.clusterListeners) {
            listener.workerAdded(new ClusterStateEvent(null, worker, node));
        }
    }

    private void notifyOnWorkerRemoved(String worker, String node) {
        for (ClusterStateListener listener : this.clusterListeners) {
            listener.workerRemoved(new ClusterStateEvent(null, worker, node));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NoDsoCluster
    implements DsoCluster {
        private final DsoNode CURRENT_NODE = new DummyDsoNode("CURRENT_NODE");
        private final DsoClusterTopology dsoClusterTopology = new DummyDsoClusterTopology();

        private NoDsoCluster() {
        }

        public DsoNode getCurrentNode() {
            return this.CURRENT_NODE;
        }

        public DsoClusterTopology getClusterTopology() {
            return this.dsoClusterTopology;
        }

        public void addClusterListener(DsoClusterListener listener) {
        }

        public void removeClusterListener(DsoClusterListener listener) {
        }

        public boolean isNodeJoined() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean areOperationsEnabled() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<DsoNode> getNodesWithObject(Object arg0) throws UnclusteredObjectException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<?, Set<DsoNode>> getNodesWithObjects(Object ... arg0) throws UnclusteredObjectException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<?, Set<DsoNode>> getNodesWithObjects(Collection<?> arg0) throws UnclusteredObjectException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public <K> Set<K> getKeysForOrphanedValues(Map<K, ?> arg0) throws UnclusteredObjectException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public <K> Set<K> getKeysForLocalValues(Map<K, ?> arg0) throws UnclusteredObjectException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private class DummyDsoNode
        implements DsoNode {
            private final String id;

            public DummyDsoNode(String id) {
                this.id = id;
            }

            public String getId() {
                return this.id;
            }

            public String getIp() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public String getHostname() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class DummyDsoClusterTopology
        implements DsoClusterTopology {
            private DummyDsoClusterTopology() {
            }

            public Collection<DsoNode> getNodes() {
                HashSet<String> nodes = new HashSet<String>();
                for (String master : ClusterState.this.mastersPerNode.keySet()) {
                    nodes.add(master);
                }
                for (String worker : ClusterState.this.workersPerNode.keySet()) {
                    nodes.add(worker);
                }
                ArrayList<DsoNode> result = new ArrayList<DsoNode>(nodes.size());
                for (String node : nodes) {
                    result.add(new DummyDsoNode(node));
                }
                return result;
            }
        }
    }
}

