/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.executor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.masterworker.AbstractWorker;
import org.terracotta.masterworker.WorkMessage;
import org.terracotta.message.topology.Topology;
import org.terracotta.message.topology.TopologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedWorkerService
extends AbstractWorker<Runnable> {
    private static final transient Logger logger = LoggerFactory.getLogger(DistributedWorkerService.class);

    public DistributedWorkerService(String topologyName) {
        this(null, topologyName, null, Executors.newSingleThreadExecutor());
    }

    public DistributedWorkerService(String workerPrefix, String topologyName) {
        this(workerPrefix, topologyName, null, Executors.newSingleThreadExecutor());
    }

    public DistributedWorkerService(String workerPrefix, String topologyName, Topology.Factory topologyFactory) {
        this(workerPrefix, topologyName, topologyFactory, Executors.newSingleThreadExecutor());
    }

    public DistributedWorkerService(String workerPrefix, String topologyName, ExecutorService executorService) {
        this(workerPrefix, topologyName, null, executorService);
    }

    public DistributedWorkerService(String workerPrefix, String topologyName, Topology.Factory topologyFactory, ExecutorService executorService) {
        super(workerPrefix, TopologyManager.getInstance().getOrCreateTopology(topologyName, topologyFactory), executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(WorkMessage<Runnable> workMessage) {
        Runnable work = workMessage.getWorkObject();
        try {
            work.run();
        }
        catch (Exception ex) {
            logger.error("Exception while running work!", (Throwable)ex);
        }
        finally {
            this.doReply(workMessage);
        }
    }
}

