/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.executor.support.DefaultDistributedWork;
import org.terracotta.executor.support.DistributedWork;
import org.terracotta.masterworker.AbstractMaster;
import org.terracotta.masterworker.Master;
import org.terracotta.masterworker.WorkMessage;
import org.terracotta.message.routing.RoundRobinRouter;
import org.terracotta.message.routing.Router;
import org.terracotta.message.topology.Topology;
import org.terracotta.message.topology.TopologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedExecutorService
extends AbstractExecutorService {
    private static final transient Logger logger = LoggerFactory.getLogger(DistributedExecutorService.class);
    private final Master<DistributedWork> masterDelegate;

    public DistributedExecutorService(String topologyName) {
        this(topologyName, (Router)new RoundRobinRouter());
    }

    public DistributedExecutorService(String topologyName, Router router) {
        this(topologyName, null, router);
    }

    public DistributedExecutorService(String topologyName, Topology.Factory topologyFactory, Router router) {
        Topology topology = TopologyManager.getInstance().getOrCreateTopology(topologyName, topologyFactory);
        this.masterDelegate = new MasterDelegate((Topology<WorkMessage<DistributedWork>, String>)topology, router);
        this.masterDelegate.start();
    }

    public List invokeAll(Collection callables) throws InterruptedException {
        this.checkShutdown();
        return super.invokeAll(callables);
    }

    public List invokeAll(Collection callables, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkShutdown();
        return super.invokeAll(callables, timeout, unit);
    }

    public Object invokeAny(Collection callables) throws InterruptedException, ExecutionException {
        this.checkShutdown();
        return super.invokeAny(callables);
    }

    public Object invokeAny(Collection callables, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkShutdown();
        return super.invokeAny(callables, timeout, unit);
    }

    public Future submit(Runnable runnable) {
        this.checkShutdown();
        return super.submit(runnable);
    }

    public Future submit(Runnable runnable, Object result) {
        this.checkShutdown();
        return super.submit(runnable, result);
    }

    public Future submit(Callable callable) {
        this.checkShutdown();
        return super.submit(callable);
    }

    @Override
    public void execute(Runnable work) {
        this.executeDistributedWork(new DefaultDistributedWork(work));
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<DistributedWork> pendingWorks = this.masterDelegate.shutdownNow();
        ArrayList<Runnable> result = new ArrayList<Runnable>(pendingWorks.size());
        for (DistributedWork work : pendingWorks) {
            result.add(work);
        }
        return result;
    }

    @Override
    public void shutdown() {
        this.masterDelegate.shutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.masterDelegate.isTerminated();
    }

    @Override
    public boolean isShutdown() {
        return this.masterDelegate.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.masterDelegate.awaitTermination(timeout, unit);
    }

    void executeDistributedWork(DistributedWork work) {
        try {
            this.masterDelegate.submit(work);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException("Unexpected exception!", ex);
        }
    }

    private void checkShutdown() {
        if (this.masterDelegate.isShutdown()) {
            throw new RejectedExecutionException("This executor service has been shutdown.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MasterDelegate
    extends AbstractMaster<DistributedWork> {
        public MasterDelegate(Topology<WorkMessage<DistributedWork>, String> topology, Router router) {
            super(topology, router);
        }

        @Override
        protected void onComplete(WorkMessage<DistributedWork> workMessage) {
            try {
                workMessage.getWorkObject().onComplete();
            }
            catch (InterruptedException ie) {
                logger.warn("Interrupted: " + ie);
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

