/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.executor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.terracotta.executor.DistributedExecutorService;
import org.terracotta.executor.support.DefaultDistributedWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedCompletionService<T>
implements CompletionService<T> {
    private final DistributedExecutorService executorDelegate;
    private final BlockingQueue<FutureTask<T>> completedWorksQueue;

    public DistributedCompletionService(DistributedExecutorService executor) {
        this.executorDelegate = executor;
        this.completedWorksQueue = new LinkedBlockingQueue<FutureTask<T>>();
    }

    @Override
    public Future<T> poll() {
        return (Future)this.completedWorksQueue.poll();
    }

    @Override
    public Future<T> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completedWorksQueue.poll(timeout, unit);
    }

    @Override
    public Future<T> take() throws InterruptedException {
        return this.completedWorksQueue.take();
    }

    @Override
    public Future<T> submit(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        FutureTask<T> f = new FutureTask<T>(callable);
        this.executorDelegate.executeDistributedWork(new CompletableDistributedWork<T>(this.completedWorksQueue, f));
        return f;
    }

    @Override
    public Future<T> submit(Runnable runnable, T result) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        FutureTask<T> f = new FutureTask<T>(runnable, result);
        this.executorDelegate.executeDistributedWork(new CompletableDistributedWork<T>(this.completedWorksQueue, f));
        return f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompletableDistributedWork<T>
    extends DefaultDistributedWork {
        private final BlockingQueue<FutureTask<T>> queue;
        private final FutureTask<T> task;

        public CompletableDistributedWork(BlockingQueue<FutureTask<T>> queue, FutureTask<T> task) {
            super(task);
            this.queue = queue;
            this.task = task;
        }

        @Override
        public void onComplete() throws Exception {
            super.onComplete();
            this.queue.put(this.task);
        }
    }
}

