/**
 * 
 * All content copyright (c) 2003-2008 Terracotta, Inc.,
 * except as may otherwise be noted in a separate copyright notice.
 * All rights reserved.
 *
 */
package org.terracotta.masterworker;

/**
 * Worker interface for listening to submitted works.
 * 
 * @param <T> Type of the work to listen to.
 */
public interface Worker<T> {

    /**
     * Start listening to submitted works.
     * 
     * @throws java.lang.Exception
     */
    public void start() throws Exception;

    /**
     * Stop listening activity.
     */
    public void stop();
}
