/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.serialization;

import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.impl.TimeSource;
import org.terracotta.cache.serialization.SerializedEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomLifespanSerializedEntry<T>
extends SerializedEntry<T> {
    private final int customTti;
    private final int customTtl;

    public CustomLifespanSerializedEntry(T deserialized, byte[] serialized, int tti, int ttl, TimeSource timeSource) {
        super(deserialized, serialized, timeSource);
        this.customTti = tti;
        this.customTtl = ttl;
    }

    public CustomLifespanSerializedEntry(T deserialized, byte[] serialized, int tti, int ttl, int createTime) {
        super(deserialized, serialized, createTime, createTime);
        this.customTti = tti;
        this.customTtl = ttl;
    }

    public CustomLifespanSerializedEntry(T deserialized, byte[] serialized, int tti, int ttl, int createTime, int lastAccessedTime) {
        super(deserialized, serialized, createTime, lastAccessedTime);
        this.customTti = tti;
        this.customTtl = ttl;
    }

    @Override
    public int expiresAt(CacheConfig config) {
        int ttl;
        int tti = this.customTti < 0 ? config.getMaxTTISeconds() : this.customTti;
        int n = ttl = this.customTtl < 0 ? config.getMaxTTLSeconds() : this.customTtl;
        if (tti == 0 && ttl == 0) {
            return Integer.MAX_VALUE;
        }
        int expiresAtTTL = ttl == 0 || ttl < 0 ? Integer.MAX_VALUE : this.getCreateTime() + ttl;
        int expiresAtTTI = tti == 0 || tti < 0 ? Integer.MAX_VALUE : this.getLastAccessedTime() + tti;
        return Math.min(expiresAtTTI, expiresAtTTL);
    }
}

