/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.impl;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.terracotta.cache.DistributedCache;
import org.terracotta.cache.TimestampedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntrySet<K, V>
extends AbstractSet<Map.Entry<K, V>> {
    private final DistributedCache<K, V> parent;
    private final Set<Map.Entry<K, TimestampedValue<V>>> dataEntrySet;

    EntrySet(DistributedCache<K, V> parent, Set<Map.Entry<K, TimestampedValue<V>>> dataEntrySet) {
        this.parent = parent;
        this.dataEntrySet = dataEntrySet;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new Itr(this.dataEntrySet.iterator());
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry
    implements Map.Entry<K, V> {
        private final K key;

        Entry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return EntrySet.this.parent.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return EntrySet.this.parent.put(this.key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, TimestampedValue<V>>> iterator;
        private Map.Entry<K, TimestampedValue<V>> current;

        Itr(Iterator<Map.Entry<K, TimestampedValue<V>>> iterator) {
            this.iterator = iterator;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            try {
                this.current = this.iterator.next();
            }
            catch (NoSuchElementException nse) {
                this.current = null;
                throw nse;
            }
            return new Entry(this.current.getKey());
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            EntrySet.this.parent.removeNoReturn(this.current.getKey());
            this.current = null;
        }
    }
}

