/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.evictor;

import java.util.concurrent.atomic.AtomicInteger;
import org.terracotta.cache.evictor.CapacityEvictionPolicyData;

public class LRUCapacityEvictionPolicyData
implements CapacityEvictionPolicyData {
    private final AtomicInteger lastUsedTime = new AtomicInteger();

    public void markUsed(int usedAtTime) {
        this.lastUsedTime.set(usedAtTime);
    }

    public int compareTo(CapacityEvictionPolicyData other) {
        if (other == null) {
            return 1;
        }
        if (!(other instanceof LRUCapacityEvictionPolicyData)) {
            return 0;
        }
        LRUCapacityEvictionPolicyData o = (LRUCapacityEvictionPolicyData)other;
        return this.lastUsedTime.get() - o.lastUsedTime.get();
    }

    public String toString() {
        return "LRUCapacityEvictionPolicyData {lastUsedTime = " + this.lastUsedTime.get() + "}";
    }

    public static class Factory
    implements CapacityEvictionPolicyData.Factory {
        public CapacityEvictionPolicyData newCapacityEvictionPolicyData() {
            return new LRUCapacityEvictionPolicyData();
        }

        public boolean isProductOfFactory(CapacityEvictionPolicyData capacityEvictionPolicyData) {
            return capacityEvictionPolicyData instanceof LRUCapacityEvictionPolicyData;
        }
    }
}

