/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.evictor;

import com.tc.object.bytecode.ManagerUtil;
import org.terracotta.cache.CacheConfigFactory;

public class EvictorLock {
    private boolean locked;
    private Thread owner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() {
        if (CacheConfigFactory.DSO_ACTIVE) {
            return ManagerUtil.tryMonitorEnter((Object)this, (int)2);
        }
        EvictorLock evictorLock = this;
        synchronized (evictorLock) {
            if (this.locked) {
                return false;
            }
            this.locked = true;
            this.owner = Thread.currentThread();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        if (CacheConfigFactory.DSO_ACTIVE) {
            ManagerUtil.monitorExit((Object)this, (int)2);
            return;
        }
        EvictorLock evictorLock = this;
        synchronized (evictorLock) {
            if (!this.locked) {
                throw new IllegalStateException("not locked");
            }
            if (Thread.currentThread() != this.owner) {
                throw new IllegalStateException("not owning thread");
            }
            this.locked = false;
            this.owner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        if (CacheConfigFactory.DSO_ACTIVE) {
            return ManagerUtil.isLocked((Object)this, (int)2);
        }
        EvictorLock evictorLock = this;
        synchronized (evictorLock) {
            return this.locked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHeldByCurrentThread() {
        if (CacheConfigFactory.DSO_ACTIVE) {
            return ManagerUtil.isHeldByCurrentThread((Object)this, (int)2);
        }
        EvictorLock evictorLock = this;
        synchronized (evictorLock) {
            return this.locked && this.owner == Thread.currentThread();
        }
    }
}

