/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.cache.evictor;

import com.tc.object.bytecode.ManagerUtil;
import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.CacheConfigFactory;
import org.terracotta.cache.evictor.Evictor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvictionScheduler {
    private final CacheConfig config;
    private final Evictor<?> evictor;
    private EvictionRunner runner;

    public EvictionScheduler(CacheConfig config, Evictor<?> evictor) {
        this.config = config;
        this.evictor = evictor;
    }

    public synchronized void start() {
        if (this.runner == null) {
            this.runner = new EvictionRunner(this.config, this.evictor);
            Thread t = new Thread((Runnable)this.runner, this.config.getName() + " Evictor");
            t.setDaemon(true);
            t.start();
        }
    }

    public synchronized void stop() {
        EvictionRunner oldRunner = this.runner;
        this.runner = null;
        if (oldRunner != null) {
            oldRunner.cancel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EvictionRunner
    implements Runnable {
        private final CacheConfig config;
        private final Evictor<?> evictor;
        private final int evictor_max_sleep_secs;
        private final int evictor_min_sleep_secs;
        private volatile boolean running = true;
        private static final String EVICTOR_MAX_SLEEP_PROP = "dmap.evictor-maximum-sleep-seconds";
        private static final String EVICTOR_MIN_SLEEP_PROP = "dmap.evictor-minimum-sleep-seconds";
        private static final int DEFAULT_MAX_EVICTOR_SLEEP = 3600;
        private static final int DEFAULT_MIN_EVICTOR_SLEEP = 1;

        public EvictionRunner(CacheConfig config, Evictor<?> evictor) {
            this.evictor = evictor;
            this.config = config;
            this.evictor_max_sleep_secs = EvictionRunner.getSleepTime(EVICTOR_MAX_SLEEP_PROP, 3600);
            this.evictor_min_sleep_secs = EvictionRunner.getSleepTime(EVICTOR_MIN_SLEEP_PROP, 1);
        }

        private static int getSleepTime(String prop, int defaultVal) {
            if (!CacheConfigFactory.DSO_ACTIVE) {
                return defaultVal;
            }
            return ManagerUtil.getTCProperties().getInt(prop, defaultVal);
        }

        public void cancel() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                do {
                    this.sleep();
                    this.evictor.run();
                } while (this.running);
            }
            finally {
                this.evictor.postRun();
            }
        }

        private int getSleepTimeSeconds() {
            int sleepSeconds = this.checkBounds(this.calculateSleepTimeFromConfig(), this.evictor_min_sleep_secs, this.evictor_max_sleep_secs);
            if (sleepSeconds <= 0) {
                throw new AssertionError((Object)("Invalid sleepTimeInSeconds: " + sleepSeconds));
            }
            return sleepSeconds;
        }

        private int checkBounds(int value, int min, int max) {
            if (value < min) {
                return min;
            }
            if (value > max) {
                return max;
            }
            return value;
        }

        private int calculateSleepTimeFromConfig() {
            int tti = this.config.getMaxTTISeconds();
            int ttl = this.config.getMaxTTLSeconds();
            if (tti == 0 && ttl == 0) {
                return Integer.MAX_VALUE;
            }
            if (tti <= 0) {
                tti = Integer.MAX_VALUE;
            }
            if (ttl <= 0) {
                ttl = Integer.MAX_VALUE;
            }
            int rv = Math.min(tti, ttl) / 2;
            return rv;
        }

        private void sleep() {
            long start = System.currentTimeMillis();
            long wakeup = this.calculateWakeup(start);
            while (System.currentTimeMillis() < wakeup) {
                this.config.waitForChange(wakeup - System.currentTimeMillis());
                wakeup = this.calculateWakeup(start);
            }
        }

        private long calculateWakeup(long start) {
            return start + (long)(this.getSleepTimeSeconds() * 1000);
        }
    }
}

