/*
 * All content copyright (c) Terracotta, Inc., except as may otherwise be noted in a separate copyright notice. All
 * rights reserved.
 */
package org.terracotta.cache.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class NonDsoSerializationStrategy implements SerializationStrategy {

  public Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
    return deserialize(data, null);
  }

  public String generateStringKeyFor(Object value) throws IOException {
    return new String(serialize(value));
  }

  public byte[] serialize(Object value) throws IOException {
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    ObjectOutputStream oos = new ObjectOutputStream(baos);
    oos.writeObject(value);
    oos.close();
    return baos.toByteArray();
  }

  public Object deserialize(byte[] data, final ClassLoader loader) throws IOException, ClassNotFoundException {
    ByteArrayInputStream bais = new ByteArrayInputStream(data);
    return new ObjectInputStream(bais) {
      @Override
      protected java.lang.Class<?> resolveClass(java.io.ObjectStreamClass desc) throws java.io.IOException,
          ClassNotFoundException {
        if (loader != null) { return loader.loadClass(desc.getName()); }
        return super.resolveClass(desc);
      }
    }.readObject();
  }
}
