/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.cache.serialization;

import com.tc.object.ClientObjectManager;
import com.tc.object.TCObject;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.api.DNAWriter;

import java.util.Map;

/**
 *
 * @author Chris Dennis
 */
public class CustomLifespanSerializedEntryApplicator extends SerializedEntryApplicator {

  public static final String CUSTOM_SERIALIZED_ENTRY = "org.terracotta.cache.serialization.CustomLifespanSerializedEntry";

  private static final String CUSTOM_TTI_FIELD                = CUSTOM_SERIALIZED_ENTRY + ".customTti";
  private static final String CUSTOM_TTL_FIELD                = CUSTOM_SERIALIZED_ENTRY + ".customTtl";

  public CustomLifespanSerializedEntryApplicator(final DNAEncoding encoding) {
    super(encoding);
  }

  @Override
  public void dehydrate(final ClientObjectManager objMgr, final TCObject tco, final DNAWriter writer, final Object pojo) {
    super.dehydrate(objMgr, tco, writer, pojo);

    Map<String, Object> values = getAllFields(pojo);
    writer.addPhysicalAction(CUSTOM_TTI_FIELD, get(values, CUSTOM_TTI_FIELD));
    writer.addPhysicalAction(CUSTOM_TTL_FIELD, get(values, CUSTOM_TTL_FIELD));
  }
}
