/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.terracotta.cache.serialization;

import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.impl.TimeSource;


/**
 * A SerializedEntry subclass that supports cache entries with custom TTI/TTL values.
 * @author Chris Dennis
 */
public class CustomLifespanSerializedEntry<T> extends SerializedEntry<T> {

    /**
   * <pre>
   * ********************************************************************************************
   * IF YOU'RE CHANGING ANYTHING ABOUT THE FIELDS IN THIS CLASS (name, type, add or remove, etc)
   * YOU MUST UPDATE BOTH THE APPLICATOR AND SERVER STATE CLASSES ACCORDINGLY!
   * ********************************************************************************************
   * </pre>
   */
  private final int customTti;
  private final int customTtl;
  
  public CustomLifespanSerializedEntry(final T deserialized, final byte[] serialized, final int tti, final int ttl, final TimeSource timeSource) {
    super(deserialized, serialized, timeSource);
    customTti = tti;
    customTtl = ttl;
  }

  public CustomLifespanSerializedEntry(final T deserialized, final byte[] serialized, final int tti, final int ttl, final int createTime) {
    super(deserialized, serialized, createTime, createTime);
    customTti = tti;
    customTtl = ttl;
  }

  public CustomLifespanSerializedEntry(final T deserialized, final byte[] serialized, final int tti, final int ttl, final int createTime, final int lastAccessedTime) {
    super(deserialized, serialized, createTime, lastAccessedTime);
    customTti = tti;
    customTtl = ttl;
  }

  @Override
  public int expiresAt(final CacheConfig config) {
    int tti = customTti < 0 ? config.getMaxTTISeconds() : customTti;
    int ttl = customTtl < 0 ? config.getMaxTTLSeconds() : customTtl;

    if (tti == UNUSED && ttl == UNUSED) { return NEVER_EXPIRE; }

    int expiresAtTTL;
    if (ttl == UNUSED || ttl < 0) {
      expiresAtTTL = NEVER_EXPIRE;
    } else {
      expiresAtTTL = getCreateTime() + ttl;
    }

    int expiresAtTTI;
    if (tti == UNUSED || tti < 0) {
      expiresAtTTI = NEVER_EXPIRE;
    } else {
      expiresAtTTI = getLastAccessedTime() + tti;
    }

    // expires at time which comes earliest between TTI and TTL
    return Math.min(expiresAtTTI, expiresAtTTL);
  }
}
