/*
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved.
 */
package org.terracotta.cache.logging;

import com.tc.logging.TCLogger;
import com.tc.object.bytecode.ManagerUtil;

public class TCLoggerConfigChangeListener implements ConfigChangeListener {
  private static final TCLogger logger = ManagerUtil.getLogger(TCLoggerConfigChangeListener.class.getName());

  public void configChanged(String cacheName, String configName, Object oldValue, Object newValue) {
    logger.info("Changed cache [" + cacheName + "]  " + configName + " from " + oldValue + " to " + newValue);
  }

}
