/*
 * All content copyright (c) 2003-2009 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package org.terracotta.cache.evictor;

import com.tc.stats.counter.CounterManager;
import com.tc.stats.counter.CounterManagerImpl;
import com.tc.stats.counter.sampled.SampledCounter;
import com.tc.stats.counter.sampled.SampledCounterConfig;

class EvictionStatisticsSampledDSO implements EvictionStatisticsSampled {
  private final CounterManager       counterManager;

  private final SampledCounterConfig sampledCounterConfig;

  private volatile SampledCounter    examinedSample;
  private volatile SampledCounter    evictedSample;

  EvictionStatisticsSampledDSO() {
    counterManager = new CounterManagerImpl();

    sampledCounterConfig = new SampledCounterConfig(1, 300, true, 0L);
  }

  public void reset() {
    shutdown();
    examinedSample = (SampledCounter) counterManager.createCounter(sampledCounterConfig);
    evictedSample = (SampledCounter) counterManager.createCounter(sampledCounterConfig);
  }

  public void shutdown() {
    if (examinedSample != null) {
      examinedSample.shutdown();
    }
    if (evictedSample != null) {
      evictedSample.shutdown();
    }
  }

  public void increment(final long additionalExamined, final long additionalEvicted) {
    if (examinedSample != null) {
      examinedSample.increment(additionalExamined);
    }
    if (evictedSample != null) {
      evictedSample.increment(additionalEvicted);
    }
  }

  public long getExaminedMostRecentSample() {
    if (examinedSample != null) {
      return examinedSample.getMostRecentSample().getCounterValue();
    } else {
      return 0;
    }
  }

  public long getEvictedMostRecentSample() {
    if (evictedSample != null) {
      return evictedSample.getMostRecentSample().getCounterValue();
    } else {
      return 0;
    }
  }
}