/*
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved.
 */
package org.terracotta.cache;

import org.terracotta.cache.impl.MutableConfig;

/**
 * <p>The CacheConfigFactory is the best and easiest place to start building a DistributedCache instance.  
 * It is used to create a new CacheConfig instance, which can be configured and then used 
 * to create a new DistributedCache.  </p>
 * 
 * <p>This interface is starting kind of bare but we expect to add methods in the future that
 * construct configs with combinations of frequently used parameters for different typical cache 
 * types.</p>
 */
public class CacheConfigFactory {

  /**
   * Helpful property that says whether Terracotta Distributed Shared Objects is running or not
   * by checking the tc.active property.
   */
  public static final boolean DSO_ACTIVE = Boolean.getBoolean("tc.active");

  private CacheConfigFactory() {
    // don't do this
  }
  
  /**
   * Construct a new cache configuration.
   * @return A new configuration with all default values.
   */
  public static CacheConfig newConfig() {
    return new MutableConfig();
  }
}
