/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.collections;

import com.tc.object.bytecode.ManagerUtil;
import java.util.concurrent.TimeUnit;
import org.terracotta.collections.FinegrainedLock;
import org.terracotta.collections.LockType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinegrainedLockDso
implements FinegrainedLock,
Comparable<FinegrainedLockDso> {
    private final transient String lockId;
    private final transient int defaultLockType;

    FinegrainedLockDso(String lockId, int defaultLockType) {
        this.lockId = lockId;
        this.defaultLockType = defaultLockType;
    }

    @Override
    public void lock() {
        ManagerUtil.beginLock((String)this.lockId, (int)this.defaultLockType);
    }

    @Override
    public void lock(LockType lockType) {
        ManagerUtil.beginLock((String)this.lockId, (int)lockType.getDsoLockType());
    }

    @Override
    public boolean tryLock() {
        return ManagerUtil.tryBeginLock((String)this.lockId, (int)this.defaultLockType);
    }

    @Override
    public boolean tryLock(LockType lockType) {
        return ManagerUtil.tryBeginLock((String)this.lockId, (int)lockType.getDsoLockType());
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return ManagerUtil.tryBeginLock((String)this.lockId, (int)this.defaultLockType, (long)unit.toNanos(timeout));
    }

    @Override
    public boolean tryLock(LockType lockType, long timeout, TimeUnit unit) throws InterruptedException {
        return ManagerUtil.tryBeginLock((String)this.lockId, (int)lockType.getDsoLockType(), (long)unit.toNanos(timeout));
    }

    @Override
    public void unlock() {
        ManagerUtil.commitLock((String)this.lockId, (int)this.defaultLockType);
    }

    @Override
    public void unlock(LockType lockType) {
        ManagerUtil.commitLock((String)this.lockId, (int)lockType.getDsoLockType());
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return ManagerUtil.isLockHeldByCurrentThread((String)this.lockId, (int)this.defaultLockType);
    }

    @Override
    public boolean isHeldByCurrentThread(LockType lockType) {
        return ManagerUtil.isLockHeldByCurrentThread((String)this.lockId, (int)lockType.getDsoLockType());
    }

    @Override
    public int compareTo(FinegrainedLockDso o) {
        return this.lockId.compareTo(o.lockId);
    }
}

