/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.collections;

import com.tc.object.ClientObjectManager;
import com.tc.object.ObjectID;
import com.tc.object.TCObject;
import com.tc.object.TraversedReferences;
import com.tc.object.applicator.PartialHashMapApplicator;
import com.tc.object.dna.api.DNA;
import com.tc.object.dna.api.DNACursor;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.api.DNAWriter;
import com.tc.object.dna.api.PhysicalAction;
import com.tc.object.loaders.LoaderDescription;
import com.tc.util.Assert;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ConcurrentDistributedMapDsoApplicator
extends PartialHashMapApplicator {
    static final String CDM_DSO_CLASSNAME = "org.terracotta.collections.ConcurrentDistributedMapDso";
    static final String CDM_DSO_APPLICATOR_CLASSNAME = "org.terracotta.collections.ConcurrentDistributedMapDsoApplicator";
    private static final String DSO_LOCK_TYPE_FIELDNAME = "dsoLockType";
    private static final String DSO_LOCK_STRATEGY_FIELDNAME = "lockStrategy";
    private static final Class[] NEW_CDM_ARGS = new Class[]{Integer.TYPE, Object.class};

    public ConcurrentDistributedMapDsoApplicator(DNAEncoding encoding) {
        super(encoding);
    }

    public TraversedReferences getPortableObjects(Object pojo, TraversedReferences addTo) {
        addTo.addNamedReference(DSO_LOCK_TYPE_FIELDNAME, this.getField(pojo, DSO_LOCK_STRATEGY_FIELDNAME));
        return super.getPortableObjects(pojo, addTo);
    }

    public void dehydrate(ClientObjectManager objMgr, TCObject tcObject, DNAWriter writer, Object pojo) {
        writer.addPhysicalAction(DSO_LOCK_TYPE_FIELDNAME, this.getField(pojo, DSO_LOCK_TYPE_FIELDNAME));
        Object lockStrategy = this.getField(pojo, DSO_LOCK_STRATEGY_FIELDNAME);
        writer.addPhysicalAction(DSO_LOCK_STRATEGY_FIELDNAME, this.getDehydratableObject(lockStrategy, objMgr));
        super.dehydrate(objMgr, tcObject, writer, pojo);
    }

    public Object getNewInstance(ClientObjectManager objMgr, DNA dna) {
        try {
            DNACursor cursor = dna.getCursor();
            Assert.assertTrue((Object)"DNA missing physical action", (boolean)cursor.next());
            PhysicalAction physicalAction = cursor.getPhysicalAction();
            Object lockType = physicalAction.getObject();
            Assert.assertTrue((Object)"DNA missing physical action", (boolean)cursor.next());
            physicalAction = cursor.getPhysicalAction();
            Object lockStrategy = objMgr.lookupObject((ObjectID)physicalAction.getObject());
            Class cdmClazz = objMgr.getClassFor(CDM_DSO_CLASSNAME, LoaderDescription.fromString((String)dna.getDefiningLoaderDescription()));
            Method newCDM = cdmClazz.getMethod("newCDM", NEW_CDM_ARGS);
            newCDM.setAccessible(true);
            return newCDM.invoke(null, lockType, lockStrategy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object getField(Object pojo, String fieldName) {
        try {
            Field f = pojo.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(pojo);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

