/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.collections;

import com.tc.exception.TCNonPortableObjectError;
import com.tc.exception.TCObjectNotFoundException;
import com.tc.logging.TCLogger;
import com.tc.object.ObjectID;
import com.tc.object.TCObject;
import com.tc.object.bytecode.AAFairDistributionPolicyMarker;
import com.tc.object.bytecode.Clearable;
import com.tc.object.bytecode.Manageable;
import com.tc.object.bytecode.ManagerUtil;
import com.tc.object.bytecode.NullManager;
import com.tc.object.bytecode.TCMap;
import com.tc.util.Assert;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.terracotta.collections.ConcurrentDistributedMapBackend;
import org.terracotta.collections.FinegrainedLock;
import org.terracotta.collections.FinegrainedLockDso;
import org.terracotta.collections.FinegrainedLockNoDso;
import org.terracotta.collections.LockStrategy;
import org.terracotta.collections.LockType;
import org.terracotta.collections.MapSizeListener;
import org.terracotta.collections.chm.ConcurrentHashMap;
import org.terracotta.collections.chm.SelectableConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentDistributedMapDso<K, V>
extends AbstractMap<K, V>
implements ConcurrentDistributedMapBackend<K, V>,
TCMap,
Manageable,
Clearable,
AAFairDistributionPolicyMarker {
    private static final TCLogger LOGGER = ManagerUtil.getLogger((String)ConcurrentDistributedMapDso.class.getName());
    private static final Object[] NO_ARGS = new Object[0];
    private volatile transient TCObject $__tc_MANAGED;
    private volatile boolean evictionEnabled = true;
    private final int dsoLockType;
    private final SelectableConcurrentHashMap store;
    private final LockStrategy<? super K> lockStrategy;
    private volatile transient MapSizeListener listener;
    private transient AtomicInteger localSize;
    private volatile transient String instanceDsoLockName = null;

    public ConcurrentDistributedMapDso(LockType lockType, LockStrategy<? super K> lockingStrategy) {
        this(lockType.getDsoLockType(), lockingStrategy);
    }

    public static <K, V> ConcurrentDistributedMapDso<K, V> newCDM(int lockLevel, Object strategy) {
        return new ConcurrentDistributedMapDso<K, V>(lockLevel, (LockStrategy)strategy);
    }

    private ConcurrentDistributedMapDso(int lockLevel, LockStrategy<? super K> lockStrategy) {
        Assert.pre((!(ManagerUtil.getManager() instanceof NullManager) ? 1 : 0) != 0);
        this.dsoLockType = lockLevel;
        this.store = new SelectableConcurrentHashMap();
        this.lockStrategy = lockStrategy;
        this.localSize = new AtomicInteger(0);
        Assert.post((this.store != null ? 1 : 0) != 0);
    }

    private String getInstanceDsoLockName() {
        if (this.instanceDsoLockName != null) {
            return this.instanceDsoLockName;
        }
        this.instanceDsoLockName = "@CDM" + this.__tc_managed().getObjectID().toLong() + ":";
        return this.instanceDsoLockName;
    }

    private String generateLockIdForKey(K key) {
        if (null == key) {
            throw new NullPointerException();
        }
        return this.lockStrategy.generateLockIdForKey(this.getInstanceDsoLockName(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (this.__tc_isManaged()) {
            Object old;
            if (null == value) {
                throw new NullPointerException();
            }
            String lockID = this.generateLockIdForKey(key);
            boolean sizeChanged = false;
            this.prefetch(key);
            this.beginLock(lockID, this.dsoLockType);
            try {
                this.pinLock(lockID);
                ConcurrentHashMap.HashEntry<K, V> e = this.store.putReturnHashEntry(key, value);
                old = e.value;
                if (old != value) {
                    this.doLogicalPut(e.key, value, old);
                    if (old == null) {
                        this.localSizeIncrement();
                        sizeChanged = true;
                    } else if (old instanceof ObjectID) {
                        this.localSizeIncrement();
                    }
                }
                old = this.lookup(old);
            }
            finally {
                this.commitLock(lockID, this.dsoLockType);
            }
            if (sizeChanged) {
                this.sizeIncrement();
            }
            return old;
        }
        V old = this.store.put(key, value);
        if (old == null) {
            this.localSizeIncrement();
            this.sizeIncrement();
        }
        return old;
    }

    private void doLogicalPut(K key, V value, Object old) {
        try {
            ManagerUtil.logicalInvoke((Object)this, (String)"put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{key, value});
        }
        catch (TCNonPortableObjectError npoe) {
            if (old != null) {
                this.store.put(key, old);
            } else {
                this.store.remove(key);
            }
            throw npoe;
        }
    }

    private void doLogicalRemove(K key) {
        ManagerUtil.logicalInvoke((Object)this, (String)"remove(Ljava/lang/Object;)Ljava/lang/Object;", (Object[])new Object[]{key});
    }

    private void doLogicalClear() {
        ManagerUtil.logicalInvoke((Object)this, (String)"clear()V", (Object[])NO_ARGS);
    }

    @Override
    public V unsafeGet(K key) {
        Object obj = this.store.get(key);
        if (obj instanceof ObjectID) {
            return null;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        if (this.__tc_isManaged()) {
            String lockID = this.generateLockIdForKey(key);
            this.beginLock(lockID, 1);
            try {
                V result = this.lookupAndFaultIn(key, this.store.get(key));
                if (result != null) {
                    this.pinLock(lockID);
                }
                V v = result;
                return v;
            }
            finally {
                this.commitLock(lockID, 1);
            }
        }
        return this.store.get(key);
    }

    @Override
    public V unlockedGet(Object key) {
        if (this.__tc_isManaged()) {
            return this.lookupAndFaultIn(key, this.store.get(key), false);
        }
        return this.store.get(key);
    }

    private Object prefetch(Object key) {
        Object obj = this.store.get(key);
        if (obj instanceof ObjectID) {
            ManagerUtil.preFetchObject((ObjectID)((ObjectID)obj));
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (this.__tc_isManaged()) {
            V old;
            String lockID = this.generateLockIdForKey(key);
            boolean sizeChanged = false;
            this.prefetch(key);
            this.beginLock(lockID, this.dsoLockType);
            try {
                ConcurrentHashMap.HashEntry oldEntry = this.store.removeReturnHashEntry(key);
                V v = old = oldEntry == null ? null : (V)oldEntry.value;
                if (old != null) {
                    this.doLogicalRemove(oldEntry.key);
                    if (!(old instanceof ObjectID)) {
                        this.localSizeDecrement();
                    }
                    sizeChanged = true;
                }
                old = this.lookup(old);
            }
            finally {
                this.commitLock(lockID, this.dsoLockType);
                this.unpinLock(lockID);
            }
            if (sizeChanged) {
                this.sizeDecrement();
            }
            return old;
        }
        Object old = this.store.remove(key);
        if (old != null) {
            this.localSizeDecrement();
            this.sizeDecrement();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNoReturn(K key) {
        if (this.__tc_isManaged()) {
            String lockID = this.generateLockIdForKey(key);
            boolean sizeChanged = false;
            this.beginLock(lockID, this.dsoLockType);
            try {
                sizeChanged = this.doRemoveNoReturn(key);
            }
            finally {
                this.commitLock(lockID, this.dsoLockType);
                this.unpinLock(lockID);
            }
            if (sizeChanged) {
                this.sizeDecrement();
            }
        } else if (this.store.remove(key) != null) {
            this.localSizeDecrement();
            this.sizeDecrement();
        }
    }

    @Override
    public void unlockedRemoveNoReturn(K key) {
        if (this.__tc_isManaged()) {
            boolean sizeChanged = this.doRemoveNoReturn(key);
            if (sizeChanged) {
                this.sizeDecrement();
            }
        } else if (this.store.remove(key) != null) {
            this.localSizeDecrement();
            this.sizeDecrement();
        }
    }

    private boolean doRemoveNoReturn(K key) {
        Object old;
        boolean sizeChanged = false;
        ConcurrentHashMap.HashEntry oldEntry = this.store.removeReturnHashEntry(key);
        Object v0 = old = oldEntry == null ? null : oldEntry.value;
        if (old != null) {
            this.doLogicalRemove(oldEntry.key);
            if (!(old instanceof ObjectID)) {
                this.localSizeDecrement();
            }
            sizeChanged = true;
        }
        return sizeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putNoReturn(K key, V value) {
        if (this.__tc_isManaged()) {
            String lockID = this.generateLockIdForKey(key);
            boolean sizeChanged = false;
            this.beginLock(lockID, this.dsoLockType);
            try {
                this.pinLock(lockID);
                sizeChanged = this.doPutNoReturn(key, value);
            }
            finally {
                this.commitLock(lockID, this.dsoLockType);
            }
            if (sizeChanged) {
                this.sizeIncrement();
            }
        } else if (this.store.put(key, value) == null) {
            this.localSizeIncrement();
            this.sizeIncrement();
        }
    }

    @Override
    public void unlockedPutNoReturn(K key, V value) {
        if (this.__tc_isManaged()) {
            boolean sizeChanged = this.doPutNoReturn(key, value);
            if (sizeChanged) {
                this.sizeIncrement();
            }
        } else if (this.store.put(key, value) == null) {
            this.localSizeIncrement();
            this.sizeIncrement();
        }
    }

    private boolean doPutNoReturn(K key, V value) {
        ConcurrentHashMap.HashEntry<K, V> e = this.store.putReturnHashEntry(key, value);
        Object old = e.value;
        if (old != value) {
            this.doLogicalPut(e.key, value, old);
            if (old == null) {
                this.localSizeIncrement();
                return true;
            }
            if (old instanceof ObjectID) {
                this.localSizeIncrement();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (this.__tc_isManaged()) {
            String lockID = this.generateLockIdForKey(key);
            this.beginLock(lockID, 1);
            try {
                boolean bl = this.store.containsKey(key);
                return bl;
            }
            finally {
                this.commitLock(lockID, 1);
            }
        }
        return this.store.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        if (this.__tc_isManaged()) {
            if (null == value) {
                throw new NullPointerException();
            }
            for (Map.Entry<K, V> entry : this.entrySet()) {
                String lockID = this.generateLockIdForKey(entry.getKey());
                this.beginLock(lockID, 1);
                try {
                    if (!value.equals(this.lookupAndFaultIn(entry.getKey(), entry.getValue()))) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.commitLock(lockID, 1);
                }
            }
            return false;
        }
        return this.store.containsValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.__tc_isManaged()) {
            this.beginLock(this.getInstanceDsoLockName(), 1);
            try {
                int n = this.store.size();
                return n;
            }
            finally {
                this.commitLock(this.getInstanceDsoLockName(), 1);
            }
        }
        return this.store.size();
    }

    @Override
    public int localSize() {
        if (this.__tc_isManaged()) {
            return this.localSize.get();
        }
        return this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.__tc_isManaged()) {
            this.beginLock(this.getInstanceDsoLockName(), this.dsoLockType);
            try {
                this.unpinAllLocks();
                int size = this.store.size();
                this.store.clear();
                int local = this.localSize.getAndSet(0);
                if (this.listener != null) {
                    this.listener.localSizeChanged(-local);
                    this.listener.sizeChanged(-size);
                }
                this.doLogicalClear();
            }
            finally {
                this.commitLock(this.getInstanceDsoLockName(), this.dsoLockType);
            }
        } else {
            int local = this.localSize.getAndSet(0);
            this.store.clear();
            int size = this.store.size();
            if (this.listener != null) {
                this.listener.localSizeChanged(-local);
                this.listener.sizeChanged(-size);
            }
        }
    }

    @Override
    public Set<K> keySet() {
        return new KeySet(this.store.keySet());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this.store.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        if (this.__tc_isManaged()) {
            V old;
            if (null == value) {
                throw new NullPointerException();
            }
            String lockID = this.generateLockIdForKey(key);
            boolean sizeChanged = false;
            this.prefetch(key);
            this.beginLock(lockID, this.dsoLockType);
            try {
                this.pinLock(lockID);
                old = this.store.putIfAbsent(key, value);
                if (old == null) {
                    this.doLogicalPut(key, value, old);
                    this.localSizeIncrement();
                    sizeChanged = true;
                }
                old = this.lookupAndFaultIn(key, old);
            }
            finally {
                this.commitLock(lockID, this.dsoLockType);
            }
            if (sizeChanged) {
                this.sizeIncrement();
            }
            return old;
        }
        V old = this.store.putIfAbsent(key, value);
        if (old == null) {
            this.localSizeIncrement();
            this.sizeIncrement();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        if (this.__tc_isManaged()) {
            if (null == value) {
                throw new NullPointerException();
            }
            String lockID = this.generateLockIdForKey(key);
            boolean success = false;
            this.beginLock(lockID, this.dsoLockType);
            try {
                this.fault(key);
                ConcurrentHashMap.HashEntry oldEntry = this.store.removeReturnHashEntry(key, value);
                if (oldEntry != null && oldEntry.value != null) {
                    this.doLogicalRemove(oldEntry.key);
                    this.localSizeDecrement();
                    success = true;
                } else {
                    success = false;
                }
            }
            finally {
                this.commitLock(lockID, this.dsoLockType);
                if (success) {
                    this.unpinLock(lockID);
                }
            }
            if (success) {
                this.sizeDecrement();
            }
            return success;
        }
        if (this.store.remove(key, value)) {
            this.localSizeDecrement();
            this.sizeDecrement();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (this.__tc_isManaged()) {
            if (null == oldValue) {
                throw new NullPointerException();
            }
            if (null == newValue) {
                throw new NullPointerException();
            }
            String lockID = this.generateLockIdForKey(key);
            this.prefetch(key);
            this.beginLock(lockID, this.dsoLockType);
            try {
                this.pinLock(lockID);
                this.fault(key);
                ConcurrentHashMap.HashEntry<K, V> e = this.store.replaceReturnHashEntry(key, oldValue, newValue);
                if (e != null) {
                    this.doLogicalPut(e.key, newValue, e.value);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.commitLock(lockID, this.dsoLockType);
            }
        }
        return this.store.replace(key, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        if (this.__tc_isManaged()) {
            if (null == value) {
                throw new NullPointerException();
            }
            String lockID = this.generateLockIdForKey(key);
            this.prefetch(key);
            this.beginLock(lockID, this.dsoLockType);
            try {
                Object old;
                ConcurrentHashMap.HashEntry<K, V> entry = this.store.replaceReturnHashEntry(key, value);
                Object v0 = old = entry == null ? null : entry.value;
                if (old != null) {
                    this.doLogicalPut(entry.key, value, old);
                    if (old instanceof ObjectID) {
                        this.localSizeIncrement();
                    }
                }
                V v = this.lookup(old);
                return v;
            }
            finally {
                this.commitLock(lockID, this.dsoLockType);
            }
        }
        return this.store.replace(key, value);
    }

    @Override
    public Collection<Map.Entry<K, V>> getAllEntriesSnapshot() {
        return Collections.unmodifiableCollection(this.store.entrySet());
    }

    @Override
    public Collection<Map.Entry<K, V>> getAllLocalEntriesSnapshot() {
        return new LocalEntriesCollection();
    }

    private void fault(Object key) {
        Object obj = this.store.get(key);
        if (obj instanceof ObjectID) {
            try {
                Object value = ManagerUtil.lookupObject((ObjectID)((ObjectID)obj));
                if (this.store.replace(key, obj, value)) {
                    this.localSizeIncrement();
                }
            }
            catch (TCObjectNotFoundException e) {
                LOGGER.info((Object)("Missing object caused by concurrent map-level and key-level operations\nRemoving local entry for this key [" + key + "] to restore L1-L2 correspondence."), (Throwable)e);
                this.store.remove(key, obj);
                this.unpinLock(this.generateLockIdForKey(key));
            }
        }
    }

    private V lookupAndFaultIn(Object key, Object obj) {
        return this.lookupAndFaultIn(key, obj, true);
    }

    private V lookupAndFaultIn(Object key, Object obj, boolean coherent) {
        if (obj instanceof ObjectID) {
            try {
                Object value = ManagerUtil.lookupObject((ObjectID)((ObjectID)obj));
                if (this.store.replace(key, obj, value)) {
                    this.localSizeIncrement();
                }
                return (V)value;
            }
            catch (TCObjectNotFoundException e) {
                if (coherent) {
                    LOGGER.info((Object)("Missing object caused by concurrent map-level and key-level operations\nRemoving local entry for this key [" + key + "] to restore L1-L2 correspondence."), (Throwable)e);
                    this.store.remove(key, obj);
                    this.unpinLock(this.generateLockIdForKey(key));
                } else {
                    String msg = "Retrieval attempt for Garbage collected object: key=" + key + ", ObjectID=" + obj.toString();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.info((Object)msg, (Throwable)e);
                    } else {
                        LOGGER.info((Object)msg);
                    }
                }
                return null;
            }
        }
        return (V)obj;
    }

    private V lookup(Object obj) {
        if (obj instanceof ObjectID) {
            try {
                return (V)ManagerUtil.lookupObject((ObjectID)((ObjectID)obj));
            }
            catch (TCObjectNotFoundException e) {
                LOGGER.info((Object)"Missing object caused by concurrent map-level and key-level operations\nReturning null as the only sensible result.  Caller should have removed the local mapping.", (Throwable)e);
                return null;
            }
        }
        return (V)obj;
    }

    public void __tc_applicator_clear() {
        this.store.clear();
    }

    public void __tc_applicator_put(Object key, Object value) {
        Object old = this.store.put(key, value);
        if (value instanceof ObjectID) {
            if (old != null && !(old instanceof ObjectID)) {
                this.localSizeDecrement();
            }
        } else if (old == null || old instanceof ObjectID) {
            this.localSizeIncrement();
        }
    }

    public void __tc_applicator_remove(Object key) {
        this.unpinLock(this.generateLockIdForKey(key));
        Object old = this.store.remove(key);
        if (old != null && !(old instanceof ObjectID)) {
            this.localSizeDecrement();
        }
    }

    public Collection __tc_getAllEntriesSnapshot() {
        return this.getAllEntriesSnapshot();
    }

    public Collection __tc_getAllLocalEntriesSnapshot() {
        return this.getAllLocalEntriesSnapshot();
    }

    public void __tc_put_logical(Object key, Object value) {
        this.putNoReturn(key, value);
    }

    public void __tc_remove_logical(Object key) {
        this.removeNoReturn(key);
    }

    public boolean __tc_isManaged() {
        return this.$__tc_MANAGED != null;
    }

    public TCObject __tc_managed() {
        return this.$__tc_MANAGED;
    }

    public void __tc_managed(TCObject tcObject) {
        this.$__tc_MANAGED = tcObject;
    }

    public int __tc_clearReferences(int toClear) {
        if (!this.__tc_isManaged()) {
            throw new AssertionError((Object)"clearReferences() called on Unmanaged Map");
        }
        int cleared = 0;
        for (Object key : this.store.keySet()) {
            ObjectID oid;
            TCObject tcObject;
            Object v = this.store.get(key);
            if (v instanceof ObjectID || (tcObject = ManagerUtil.lookupExistingOrNull(v)) == null || tcObject.recentlyAccessed() || !this.store.replaceUsingReferenceEquality(key, v, oid = tcObject.getObjectID())) continue;
            this.localSizeDecrement();
            this.unpinLock(this.generateLockIdForKey(key));
            if (++cleared != toClear) continue;
            break;
        }
        return cleared;
    }

    public boolean isEvictionEnabled() {
        return this.evictionEnabled;
    }

    public void setEvictionEnabled(boolean flag) {
        this.evictionEnabled = flag;
    }

    private void pinLock(String lockId) {
        this.lockStrategy.pinLock(lockId);
    }

    private void commitLock(String lockID, int type) {
        this.lockStrategy.commitLock(lockID, type);
    }

    private void beginLock(String lockID, int type) {
        this.lockStrategy.beginLock(lockID, type);
    }

    private void unpinLock(String lock) {
        this.lockStrategy.unpinLock(lock);
    }

    private void unpinAllLocks() {
        for (Object key : this.store.keySet()) {
            this.unpinLock(this.generateLockIdForKey(key));
        }
    }

    @Override
    public FinegrainedLock createFinegrainedLock(K key) {
        if (this.__tc_isManaged()) {
            String lockId = this.generateLockIdForKey(key);
            if (lockId == null) {
                throw new UnsupportedOperationException("fine grained lock not supported with null lock for key [" + key + "]");
            }
            return new FinegrainedLockDso(lockId, this.dsoLockType);
        }
        return new FinegrainedLockNoDso();
    }

    @Override
    public void lockEntry(K key) {
        if (this.__tc_isManaged()) {
            String lockId = this.generateLockIdForKey(key);
            this.beginLock(lockId, this.dsoLockType);
            this.pinLock(lockId);
        }
    }

    @Override
    public void unlockEntry(K key) {
        if (this.__tc_isManaged()) {
            String lockId = this.generateLockIdForKey(key);
            boolean validKey = this.containsKey(key);
            this.commitLock(lockId, this.dsoLockType);
            if (!validKey) {
                this.unpinLock(lockId);
            }
        }
    }

    @Override
    public String getLockIdForKey(K key) {
        if (this.__tc_isManaged()) {
            String lockId = this.generateLockIdForKey(key);
            if (lockId == null) {
                throw new UnsupportedOperationException("null lock for key [" + key + "]");
            }
            return lockId;
        }
        return "";
    }

    @Override
    public List<Map<K, ?>> getConstituentMaps() {
        return Collections.singletonList(this);
    }

    @Override
    public Map.Entry<K, V> getRandomEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.store.getRandomEntry();
    }

    @Override
    public Map.Entry<K, V> getRandomLocalEntry() {
        if (this.localSize() == 0) {
            return null;
        }
        return this.store.getRandomLocalEntry();
    }

    @Override
    public boolean flush(Object key, Object value) {
        if (this.__tc_isManaged()) {
            if (value instanceof ObjectID) {
                return false;
            }
            TCObject tcObject = ManagerUtil.lookupExistingOrNull((Object)value);
            if (tcObject == null) {
                return false;
            }
            ObjectID oid = tcObject.getObjectID();
            boolean success = this.store.replaceUsingReferenceEquality(key, value, oid);
            if (success) {
                this.localSizeDecrement();
                this.unpinLock(this.generateLockIdForKey(key));
            }
            return success;
        }
        return this.remove(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryRemove(Object key, long time, TimeUnit unit) {
        if (this.__tc_isManaged()) {
            String lockID = this.generateLockIdForKey(key);
            try {
                if (this.tryBeginLock(lockID, this.dsoLockType, unit.toNanos(time))) {
                    boolean removed = false;
                    try {
                        Object old;
                        ConcurrentHashMap.HashEntry oldEntry = this.store.removeReturnHashEntry(key);
                        Object v0 = old = oldEntry == null ? null : oldEntry.value;
                        if (old != null) {
                            this.doLogicalRemove(oldEntry.key);
                            if (!(old instanceof ObjectID)) {
                                this.localSizeDecrement();
                            }
                            removed = true;
                        }
                    }
                    finally {
                        this.commitLock(lockID, this.dsoLockType);
                        this.unpinLock(lockID);
                    }
                    if (removed) {
                        this.sizeDecrement();
                    }
                    return removed;
                }
                return false;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        if (this.store.remove(key) != null) {
            this.localSizeDecrement();
            this.sizeDecrement();
            return true;
        }
        return false;
    }

    private boolean tryBeginLock(String lockID, int type, long nanos) throws InterruptedException {
        return this.lockStrategy.tryBeginLock(lockID, type, nanos);
    }

    private void localSizeIncrement() {
        this.localSize.incrementAndGet();
        MapSizeListener l = this.listener;
        if (l != null) {
            l.localSizeChanged(1);
        }
    }

    private void localSizeDecrement() {
        this.localSize.decrementAndGet();
        MapSizeListener l = this.listener;
        if (l != null) {
            l.localSizeChanged(-1);
        }
    }

    private void sizeIncrement() {
        MapSizeListener l = this.listener;
        if (l != null) {
            l.sizeChanged(1);
        }
    }

    private void sizeDecrement() {
        MapSizeListener l = this.listener;
        if (l != null) {
            l.sizeChanged(-1);
        }
    }

    @Override
    public MapSizeListener registerMapSizeListener(MapSizeListener newListener) {
        MapSizeListener old = this.listener;
        this.listener = newListener;
        return old;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalEntriesIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> delegate;
        private Map.Entry<K, V> next;

        public LocalEntriesIterator(Iterator<Map.Entry<K, V>> delegate) {
            this.delegate = delegate;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry<K, V> result = this.findNext();
            if (result == null) {
                throw new NoSuchElementException();
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Map.Entry<K, V> findNext() {
            Map.Entry<K, V> current = this.next;
            while (this.delegate.hasNext()) {
                Map.Entry<K, V> obj = this.delegate.next();
                if (obj.getValue() instanceof ObjectID) continue;
                this.next = obj;
                return current;
            }
            this.next = null;
            return current;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalEntriesCollection
    extends AbstractCollection<Map.Entry<K, V>> {
        private final Collection<Map.Entry<K, V>> delegate;

        private LocalEntriesCollection() {
            this.delegate = ConcurrentDistributedMapDso.this.store.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LocalEntriesIterator(this.delegate.iterator());
        }

        @Override
        public int size() {
            int size = 0;
            for (Object o : ConcurrentDistributedMapDso.this.store.values()) {
                if (o instanceof ObjectID) continue;
                ++size;
            }
            return size;
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TcmEntry
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        private TcmEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            Object old = this.value;
            ConcurrentDistributedMapDso.this.put(this.key, newValue);
            this.value = newValue;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.eq(this.key, e.getKey()) && this.eq(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.getValue();
        }

        private boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> delegate;
        private Map.Entry<K, V> lastEntry;

        private EntryIterator(Iterator<Map.Entry<K, V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public synchronized Map.Entry<K, V> next() {
            Map.Entry result = this.delegate.next();
            if (null == result) {
                this.lastEntry = null;
                return null;
            }
            Object key = result.getKey();
            this.lastEntry = new TcmEntry(key, ConcurrentDistributedMapDso.this.get(key));
            return this.lastEntry;
        }

        @Override
        public synchronized void remove() {
            if (null == this.lastEntry) {
                throw new IllegalStateException("next needs to be called before calling remove");
            }
            ConcurrentDistributedMapDso.this.remove(this.lastEntry.getKey(), this.lastEntry.getValue());
            this.lastEntry = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<K, V>> delegate;

        private EntrySet(Set<Map.Entry<K, V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.delegate.iterator());
        }

        @Override
        public int size() {
            return ConcurrentDistributedMapDso.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = ConcurrentDistributedMapDso.this.get(e.getKey());
            return value != null && value.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentDistributedMapDso.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public void clear() {
            ConcurrentDistributedMapDso.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    implements Iterator<K> {
        private final Iterator<K> delegate;
        private K lastKey;

        public KeyIterator(Iterator<K> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public K next() {
            Object result = this.delegate.next();
            this.lastKey = result;
            return result;
        }

        @Override
        public void remove() {
            if (null == this.lastKey) {
                throw new IllegalStateException("next needs to be called before calling remove");
            }
            if (ManagerUtil.isManaged((Object)ConcurrentDistributedMapDso.this)) {
                ConcurrentDistributedMapDso.this.remove(this.lastKey);
            } else {
                this.delegate.remove();
            }
            this.lastKey = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private final Set<K> delegate;

        private KeySet(Set<K> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return ConcurrentDistributedMapDso.this.size();
        }

        @Override
        public boolean contains(Object key) {
            return ConcurrentDistributedMapDso.this.containsKey(key);
        }

        @Override
        public void clear() {
            ConcurrentDistributedMapDso.this.clear();
        }

        @Override
        public boolean remove(Object key) {
            return ConcurrentDistributedMapDso.this.remove(key) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(this.delegate.iterator());
        }
    }
}

