/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.sequence;

import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;
import org.terracotta.management.sequence.NodeIdSource;
import org.terracotta.management.sequence.TimeSource;

class Defaults {
    private static final int PID_BITLENGTH = 16;
    private static final long PID_BITMASK = 65535L;
    private static final byte[] NO_MAC = new byte[6];
    static final int SEQ_BITLENGTH = 18;
    static final long SEQ_BITMASK = 262143L;
    static final int INSTANCE_BITLENGTH = 18;
    static final int INSTANCE_BITMASK = 262143;
    static final NodeIdSource MAC_PID_NODE_ID_SOURCE;
    static final NodeIdSource BEST_NODE_ID_SOURCE;
    static final TimeSource SYSTEM_TIME_SOURCE;
    static final TimeSource BEST_TIME_SOURCE;
    private static final Comparator<NetworkInterface> NETWORK_INTERFACE_COMPARATOR;

    Defaults() {
    }

    static byte[] readMacAddress() {
        byte[] mac;
        ArrayList<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
        }
        catch (SocketException e) {
            return NO_MAC;
        }
        Collections.sort(networkInterfaces, NETWORK_INTERFACE_COMPARATOR);
        for (NetworkInterface networkInterface : networkInterfaces) {
            try {
                if (networkInterface.isLoopback() || networkInterface.isPointToPoint() || networkInterface.isVirtual() || networkInterface.getParent() != null || (mac = networkInterface.getHardwareAddress()) == null || mac.length < 6) continue;
                return mac;
            }
            catch (SocketException ignored) {
            }
        }
        for (NetworkInterface networkInterface : networkInterfaces) {
            try {
                if (networkInterface.isLoopback() || (mac = networkInterface.getHardwareAddress()) == null || mac.length < 6) continue;
                return mac;
            }
            catch (SocketException socketException) {
            }
        }
        return NO_MAC;
    }

    static long readPID() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        long pid = 0L;
        for (int i = 0; i < name.length() && Character.isDigit(name.charAt(i)); ++i) {
            pid = pid * 10L + (long)Character.getNumericValue(name.charAt(i));
        }
        return pid;
    }

    private static <T> T findBest(Class<T> type, T def) {
        String cName = System.getProperty(type.getName());
        if (cName != null) {
            try {
                return type.cast(Defaults.class.getClassLoader().loadClass(cName).newInstance());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate  " + type.getSimpleName() + " " + cName + " set from system property");
            }
        }
        try {
            return ServiceLoader.load(type).iterator().next();
        }
        catch (Exception exception) {
            return def;
        }
    }

    static /* synthetic */ Object access$000(Class x0, Object x1) {
        return Defaults.findBest(x0, x1);
    }

    static {
        byte b = 0;
        Arrays.fill(NO_MAC, b);
        MAC_PID_NODE_ID_SOURCE = new NodeIdSource(){

            @Override
            public long getNodeId() {
                byte[] mac = Defaults.readMacAddress();
                long nodeId = 0L;
                for (int i = Math.max(0, mac.length - 6); i < mac.length; ++i) {
                    nodeId = nodeId << 8 | (long)(mac[i] & 0xFF);
                }
                return nodeId << 16 & Long.MAX_VALUE | Defaults.readPID() & 0xFFFFL;
            }
        };
        BEST_NODE_ID_SOURCE = new NodeIdSource(){
            final NodeIdSource delegate = (NodeIdSource)Defaults.access$000(NodeIdSource.class, MAC_PID_NODE_ID_SOURCE);

            @Override
            public long getNodeId() {
                return this.delegate.getNodeId();
            }
        };
        SYSTEM_TIME_SOURCE = new TimeSource(){

            @Override
            public long getTimestamp() {
                return System.currentTimeMillis();
            }
        };
        BEST_TIME_SOURCE = new TimeSource(){
            final TimeSource delegate = (TimeSource)Defaults.access$000(TimeSource.class, SYSTEM_TIME_SOURCE);

            @Override
            public long getTimestamp() {
                return this.delegate.getTimestamp();
            }
        };
        NETWORK_INTERFACE_COMPARATOR = new Comparator<NetworkInterface>(){

            @Override
            public int compare(NetworkInterface o1, NetworkInterface o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
    }
}

