/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.sequence.perf;

import java.util.Arrays;
import java.util.concurrent.CyclicBarrier;
import org.terracotta.management.sequence.BoundaryFlakeSequenceGenerator;
import org.terracotta.management.sequence.NodeIdSource;
import org.terracotta.management.sequence.TimeSource;

public class PerfTest {
    private static final BoundaryFlakeSequenceGenerator generator = new BoundaryFlakeSequenceGenerator(TimeSource.BEST, NodeIdSource.BEST);

    public static void main(String[] args) throws InterruptedException {
        int[] counts = new int[10];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = PerfTest.genMs(1000);
        }
        System.out.println("Number of generated sequence per ms: " + PerfTest.toStat(counts) + "\n" + Arrays.toString(counts));
        final CyclicBarrier barrier = new CyclicBarrier(Runtime.getRuntime().availableProcessors());
        final int[][] counts2 = new int[barrier.getParties()][];
        Thread[] threads = new Thread[barrier.getParties()];
        for (int i = 0; i < barrier.getParties(); ++i) {
            final int tid = i;
            counts2[i] = new int[10];
            threads[i] = new Thread("thread-" + tid){

                @Override
                public void run() {
                    try {
                        barrier.await();
                    }
                    catch (Exception ignored) {
                        return;
                    }
                    for (int i = 0; i < counts2[tid].length; ++i) {
                        counts2[tid][i] = PerfTest.genMs(1000);
                    }
                }
            };
            threads[i].start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        for (int i = 0; i < counts2.length; ++i) {
            System.out.println("{thread-" + i + "}\nNumber of generated sequence per ms: " + PerfTest.toStat(counts2[i]) + "\n" + Arrays.toString(counts2[i]));
        }
    }

    private static Stat toStat(int[] counts) {
        Arrays.sort(counts);
        int mean = 0;
        int[] nArray = counts;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long count = nArray[i];
            mean = (int)((long)mean + count);
        }
        return new Stat(counts[0], counts[counts.length - 1], mean / counts.length);
    }

    private static int genMs(int durationMs) {
        int n = 0;
        long time = System.currentTimeMillis();
        while (generator.next().getTimestamp() - time < (long)durationMs) {
            ++n;
        }
        return n / durationMs;
    }

    static class Stat {
        final int mean;
        final int min;
        final int max;

        Stat(int min, int max, int mean) {
            this.min = min;
            this.max = max;
            this.mean = mean;
        }

        public String toString() {
            return "min=" + this.mean + ", max=" + this.max + ", mean=" + this.mean;
        }
    }
}

