/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.capabilities.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.model.context.Context;

public final class CapabilityContext
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(CapabilityContext.class);
    private static final long serialVersionUID = 1L;
    private final Collection<Attribute> attributes;

    public CapabilityContext(Attribute ... attributes) {
        this(Arrays.asList(attributes));
    }

    public CapabilityContext(Collection<Attribute> attributes) {
        this.attributes = new ArrayList<Attribute>(Objects.requireNonNull(attributes));
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes;
    }

    public Collection<String> getRequiredAttributeNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Attribute attribute : this.attributes) {
            if (!attribute.isRequired()) continue;
            names.add(attribute.getName());
        }
        return names;
    }

    public boolean isValid(Context context) {
        if (context == null) {
            return false;
        }
        for (Attribute attribute : this.getRequiredAttributes()) {
            if (context.get(attribute.getName()) != null) continue;
            logger.debug("Required attribute: {} not found in context: {}", (Object)attribute.getName(), (Object)context);
            return false;
        }
        return true;
    }

    public Collection<Attribute> getRequiredAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.attributes.size());
        for (Attribute attribute : this.attributes) {
            if (!attribute.isRequired()) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CapabilityContext{");
        sb.append("attributes=").append(this.attributes);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapabilityContext that = (CapabilityContext)o;
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public static final class Attribute
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final boolean required;

        public Attribute(String name, boolean required) {
            this.name = Objects.requireNonNull(name);
            this.required = required;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute attribute = (Attribute)o;
            if (this.required != attribute.required) {
                return false;
            }
            return this.name.equals(attribute.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.required ? 1 : 0);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Attribute{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", required=").append(this.required);
            sb.append('}');
            return sb.toString();
        }
    }
}

