/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.terracotta.management.model.Objects;

public final class ClientIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ClientIdentifier.class.getName());
    private final long pid;
    private final String name;
    private final String connectionUid;
    private final String hostAddress;

    private ClientIdentifier(long pid, String hostAddress, String name, String connectionUid) {
        this.hostAddress = Objects.requireNonNull(hostAddress);
        this.pid = pid;
        this.connectionUid = Objects.requireNonNull(connectionUid);
        this.name = Objects.requireNonNull(name);
        if (hostAddress.isEmpty()) {
            throw new IllegalArgumentException("Empty host address");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Empty name");
        }
    }

    public String getConnectionUid() {
        return this.connectionUid;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public long getPid() {
        return this.pid;
    }

    public String getName() {
        return this.name;
    }

    public String getVmId() {
        return this.pid + "@" + this.hostAddress;
    }

    public String getClientId() {
        return this.getVmId() + ":" + this.name + ":" + this.connectionUid;
    }

    public String toString() {
        return this.getClientId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientIdentifier that = (ClientIdentifier)o;
        return this.pid == that.pid && this.name.equals(that.name) && this.connectionUid.equals(that.connectionUid) && this.hostAddress.equals(that.hostAddress);
    }

    public int hashCode() {
        int result = (int)(this.pid ^ this.pid >>> 32);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.connectionUid.hashCode();
        result = 31 * result + this.hostAddress.hashCode();
        return result;
    }

    public static ClientIdentifier create(long pid, String hostAddress, String name, String uuid) {
        return new ClientIdentifier(pid, hostAddress, name, uuid);
    }

    public static ClientIdentifier create(String name, String logicalConnectionUid) {
        try {
            InetAddress inetAddress = ClientIdentifier.discoverLANAddress();
            return new ClientIdentifier(ClientIdentifier.discoverPID(), inetAddress.getHostAddress(), name, logicalConnectionUid);
        }
        catch (UnknownHostException e) {
            return new ClientIdentifier(ClientIdentifier.discoverPID(), "127.0.0.1", name, logicalConnectionUid);
        }
    }

    public static ClientIdentifier valueOf(String identifier) {
        try {
            int copy = identifier.indexOf(64);
            int firstColon = identifier.indexOf(58, copy + 1);
            int lastColon = identifier.lastIndexOf(58);
            return new ClientIdentifier(Long.parseLong(identifier.substring(0, copy)), identifier.substring(copy + 1, firstColon), identifier.substring(firstColon + 1, lastColon), identifier.substring(lastColon + 1));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(identifier);
        }
    }

    static String discoverHostName() {
        String hostname;
        block9: {
            hostname = null;
            try {
                Process process;
                String procname = "hostname";
                if (System.getProperty("os.name", "").toLowerCase().contains("win")) {
                    procname = procname + ".exe";
                }
                if ((process = Runtime.getRuntime().exec(procname)).waitFor() == 0) {
                    int r;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream in = process.getInputStream();
                    while ((r = in.read()) != -1) {
                        baos.write(r);
                    }
                    in.close();
                    hostname = new String(baos.toByteArray(), "UTF-8");
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block9;
                LOGGER.log(Level.FINEST, "ERR getHostName(): " + e.getMessage(), e);
            }
        }
        if (hostname != null) {
            return hostname;
        }
        try {
            InetAddress address = ClientIdentifier.discoverLANAddress();
            String resolved = address.getCanonicalHostName();
            if (!address.getHostAddress().equals(resolved)) {
                hostname = resolved;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostname;
    }

    static String generateNewUUID() {
        int i;
        UUID j = UUID.randomUUID();
        byte[] data = new byte[16];
        long msb = j.getMostSignificantBits();
        long lsb = j.getLeastSignificantBits();
        for (i = 0; i < 8; ++i) {
            data[i] = (byte)(msb & 0xFFL);
            msb >>>= 8;
        }
        for (i = 8; i < 16; ++i) {
            data[i] = (byte)(lsb & 0xFFL);
            lsb >>>= 8;
        }
        return DatatypeConverter.printBase64Binary((byte[])data).replace('+', '-').replace('/', '_').replace("=", "");
    }

    static long discoverPID() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        long pid = 0L;
        for (int i = 0; i < name.length() && Character.isDigit(name.charAt(i)); ++i) {
            pid = pid * 10L + (long)Character.getNumericValue(name.charAt(i));
        }
        return pid;
    }

    static InetAddress discoverLANAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (!inetAddress.isLoopbackAddress() && inetAddress.isSiteLocalAddress()) {
            return inetAddress;
        }
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }
}

