/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.call;

import java.util.Arrays;
import org.terracotta.management.model.Objects;
import org.terracotta.management.model.call.Parameter;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.context.Contextual;

public class ContextualCall<T>
implements Contextual {
    private static final long serialVersionUID = 1L;
    private Context context;
    private final String capability;
    private final String methodName;
    private final Class<T> returnType;
    private final Parameter[] parameters;

    public ContextualCall(Context context, String capability, String methodName, Class<T> returnType, Parameter ... parameters) {
        this.context = Objects.requireNonNull(context);
        this.capability = Objects.requireNonNull(capability);
        this.methodName = Objects.requireNonNull(methodName);
        this.returnType = Objects.requireNonNull(returnType);
        this.parameters = Objects.requireNonNull(parameters);
    }

    public String getCapability() {
        return this.capability;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        this.context = Objects.requireNonNull(context);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Parameter[] getParameters() {
        return Arrays.copyOf(this.parameters, this.parameters.length);
    }

    public Class<T> getReturnType() {
        return this.returnType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContextualCall that = (ContextualCall)o;
        if (!this.context.equals(that.context)) {
            return false;
        }
        if (!this.capability.equals(that.capability)) {
            return false;
        }
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        if (!this.returnType.equals(that.returnType)) {
            return false;
        }
        return Arrays.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.context.hashCode();
        result = 31 * result + this.capability.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ContextualCall{");
        sb.append("context=").append(this.context);
        sb.append(", capability='").append(this.capability).append('\'');
        sb.append(", methodName='").append(this.methodName).append('\'');
        sb.append(", returnType=").append(this.returnType);
        sb.append('}');
        return sb.toString();
    }
}

