/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.stats;

import java.io.Serializable;
import org.terracotta.management.model.Objects;
import org.terracotta.management.model.stats.Statistic;

public abstract class AbstractStatistic<V, U>
implements Statistic<V, U>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final V value;
    private final U unit;

    public AbstractStatistic(V value, U unit) {
        this.value = Objects.requireNonNull(value);
        this.unit = Objects.requireNonNull(unit);
    }

    @Override
    public final U getUnit() {
        return this.unit;
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    public String toString() {
        return "{type='" + this.getClass().getSimpleName() + '\'' + ", value=" + this.getValue() + ", unit=" + this.getUnit() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStatistic that = (AbstractStatistic)o;
        if (!this.value.equals(that.value)) {
            return false;
        }
        return this.unit.equals(that.unit);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.unit.hashCode();
        return result;
    }
}

