/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.notification;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.context.Contextual;

public final class ContextualNotification
implements Contextual {
    private static final long serialVersionUID = 1L;
    private final String type;
    private Context context;
    private final Map<String, String> attributes;

    public ContextualNotification(Context context, String type, Map<String, String> attributes) {
        this.context = Objects.requireNonNull(context);
        this.type = Objects.requireNonNull(type);
        this.attributes = new HashMap<String, String>(Objects.requireNonNull(attributes));
    }

    public ContextualNotification(Context context, String type) {
        this(context, type, Collections.emptyMap());
    }

    @Override
    public void setContext(Context context) {
        this.context = Objects.requireNonNull(context);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "ContextualNotification{type='" + this.type + "', context=" + this.context + ", attributes=" + this.attributes + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualNotification that = (ContextualNotification)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.context.equals(that.context)) {
            return false;
        }
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.context.hashCode();
        result = 31 * result + this.attributes.hashCode();
        return result;
    }
}

