/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.cluster;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.logging.Logger;

public final class ClientIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ClientIdentifier.class.getName());
    private final long pid;
    private final String name;
    private final String connectionUid;
    private final String hostAddress;

    private ClientIdentifier(long pid, String hostAddress, String name, String connectionUid) {
        this.hostAddress = Objects.requireNonNull(hostAddress);
        this.pid = pid;
        this.connectionUid = Objects.requireNonNull(connectionUid);
        this.name = Objects.requireNonNull(name);
        if (hostAddress.isEmpty()) {
            throw new IllegalArgumentException("Empty host address");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Empty name");
        }
    }

    public String getConnectionUid() {
        return this.connectionUid;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public long getPid() {
        return this.pid;
    }

    public String getName() {
        return this.name;
    }

    public String getVmId() {
        Object ha = this.hostAddress;
        if (this.hostAddress.contains(":")) {
            ha = "[" + this.hostAddress + "]";
        }
        return this.pid + "@" + (String)ha;
    }

    public String getClientId() {
        return this.getVmId() + ":" + this.name + ":" + this.connectionUid;
    }

    public String getAppId() {
        return this.getVmId() + ":" + this.name;
    }

    public String toString() {
        return this.getClientId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientIdentifier that = (ClientIdentifier)o;
        return this.pid == that.pid && this.name.equals(that.name) && this.connectionUid.equals(that.connectionUid) && this.hostAddress.equals(that.hostAddress);
    }

    public int hashCode() {
        int result = (int)(this.pid ^ this.pid >>> 32);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.connectionUid.hashCode();
        result = 31 * result + this.hostAddress.hashCode();
        return result;
    }

    public static ClientIdentifier create(long pid, String hostAddress, String name, String uuid) {
        return new ClientIdentifier(pid, hostAddress, name, uuid);
    }

    public static ClientIdentifier create(String hostname, String name, String logicalConnectionUid) {
        return new ClientIdentifier(ClientIdentifier.discoverPID(), hostname, name, logicalConnectionUid);
    }

    public static ClientIdentifier valueOf(String identifier) {
        try {
            int firstColon;
            String hostAddress;
            int ampIdx = identifier.indexOf(64);
            if (identifier.charAt(ampIdx + 1) == '[') {
                int end = identifier.indexOf("]");
                hostAddress = identifier.substring(ampIdx + 2, end);
                firstColon = identifier.indexOf(58, end + 1);
            } else {
                firstColon = identifier.indexOf(58, ampIdx + 1);
                hostAddress = identifier.substring(ampIdx + 1, firstColon);
            }
            int lastColon = identifier.lastIndexOf(58);
            return new ClientIdentifier(Long.parseLong(identifier.substring(0, ampIdx)), hostAddress, identifier.substring(firstColon + 1, lastColon), identifier.substring(lastColon + 1));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(identifier);
        }
    }

    static long discoverPID() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        long pid = 0L;
        for (int i = 0; i < name.length() && Character.isDigit(name.charAt(i)); ++i) {
            pid = pid * 10L + (long)Character.getNumericValue(name.charAt(i));
        }
        return pid;
    }
}

