/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.call;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.context.Contextual;

public final class ContextualReturn<T>
implements Contextual {
    private static final long serialVersionUID = 1L;
    private final T value;
    private Context context;
    private final String capability;
    private final String methodName;
    private final ExecutionException error;
    private final boolean executed;

    private ContextualReturn(String capability, Context context, String methodName, T value, ExecutionException error, boolean executed) {
        this.methodName = methodName;
        this.value = value;
        this.context = Objects.requireNonNull(context);
        this.capability = Objects.requireNonNull(capability);
        this.error = error;
        this.executed = executed;
    }

    public boolean hasExecuted() {
        return this.executed;
    }

    public boolean errorThrown() {
        return this.error != null;
    }

    public T getValue() throws NoSuchElementException, ExecutionException {
        if (!this.hasExecuted()) {
            throw new NoSuchElementException("Query has not been executed: capability=" + this.capability + ", method=" + this.methodName + ", context=" + this.context);
        }
        if (this.error != null) {
            throw this.error;
        }
        return this.value;
    }

    @Override
    public void setContext(Context context) {
        this.context = Objects.requireNonNull(context);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public static <T> ContextualReturn<T> of(String capability, Context context, String methodName, T result) {
        return new ContextualReturn<T>(capability, context, methodName, result, null, true);
    }

    public static <T> ContextualReturn<T> notExecuted(String capability, Context context, String methodName) {
        return new ContextualReturn<Object>(capability, context, methodName, null, null, false);
    }

    public static <T> ContextualReturn<T> error(String capability, Context context, String methodName, ExecutionException throwable) {
        return new ContextualReturn<Object>(capability, context, methodName, null, throwable, true);
    }

    public String getCapability() {
        return this.capability;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String toString() {
        return "ContextualReturn{capability='" + this.capability + "', method='" + this.methodName + "', context=" + this.context + ", executed=" + this.executed + ", error=" + (this.error != null) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualReturn that = (ContextualReturn)o;
        if (this.executed != that.executed) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        if (!this.context.equals(that.context)) {
            return false;
        }
        if (!this.capability.equals(that.capability)) {
            return false;
        }
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        return Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.context.hashCode();
        result = 31 * result + this.capability.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.executed ? 1 : 0);
        return result;
    }
}

