/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.capabilities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.terracotta.management.model.Objects;
import org.terracotta.management.model.capabilities.Capability;
import org.terracotta.management.model.capabilities.context.CapabilityContext;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;

public final class StatisticsCapability
implements Capability,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Properties properties;
    private final Collection<? extends Descriptor> descriptors;
    private final CapabilityContext capabilityContext;

    public StatisticsCapability(String name, Properties properties, CapabilityContext capabilityContext, Descriptor ... descriptors) {
        this(name, properties, Arrays.asList(descriptors), capabilityContext);
    }

    public StatisticsCapability(String name, Properties properties, Collection<? extends Descriptor> descriptors, CapabilityContext capabilityContext) {
        this.name = Objects.requireNonNull(name);
        this.properties = Objects.requireNonNull(properties);
        this.descriptors = Objects.requireNonNull(descriptors);
        this.capabilityContext = Objects.requireNonNull(capabilityContext);
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Collection<? extends Descriptor> getDescriptors() {
        return this.descriptors;
    }

    @Override
    public <T extends Descriptor> Collection<T> getDescriptors(Class<T> descriptorType) {
        ArrayList<T> list = new ArrayList<T>();
        for (Descriptor descriptor : this.descriptors) {
            if (!descriptorType.isInstance(descriptor)) continue;
            list.add(descriptorType.cast(descriptor));
        }
        return list;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CapabilityContext getCapabilityContext() {
        return this.capabilityContext;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StatisticsCapability{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", properties=").append(this.properties);
        sb.append(", capabilityContext=").append(this.capabilityContext);
        sb.append(", descriptors=").append(this.descriptors);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticsCapability that = (StatisticsCapability)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.properties.equals(that.properties)) {
            return false;
        }
        if (!((Object)this.descriptors).equals(that.descriptors)) {
            return false;
        }
        return this.capabilityContext.equals(that.capabilityContext);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.properties.hashCode();
        result = 31 * result + ((Object)this.descriptors).hashCode();
        result = 31 * result + this.capabilityContext.hashCode();
        return result;
    }

    public static class Properties
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long averageWindowDuration;
        private final TimeUnit averageWindowUnit;
        private final int historySize;
        private final long historyInterval;
        private final TimeUnit historyIntervalUnit;
        private final long timeToDisable;
        private final TimeUnit timeToDisableUnit;

        public Properties(long averageWindowDuration, TimeUnit averageWindowUnit, int historySize, long historyInterval, TimeUnit historyIntervalUnit, long timeToDisable, TimeUnit timeToDisableUnit) {
            this.averageWindowDuration = averageWindowDuration;
            this.averageWindowUnit = Objects.requireNonNull(averageWindowUnit);
            this.historySize = historySize;
            this.historyInterval = historyInterval;
            this.historyIntervalUnit = Objects.requireNonNull(historyIntervalUnit);
            this.timeToDisable = timeToDisable;
            this.timeToDisableUnit = Objects.requireNonNull(timeToDisableUnit);
        }

        public long getAverageWindowDuration() {
            return this.averageWindowDuration;
        }

        public TimeUnit getAverageWindowUnit() {
            return this.averageWindowUnit;
        }

        public int getHistorySize() {
            return this.historySize;
        }

        public long getHistoryInterval() {
            return this.historyInterval;
        }

        public TimeUnit getHistoryIntervalUnit() {
            return this.historyIntervalUnit;
        }

        public long getTimeToDisable() {
            return this.timeToDisable;
        }

        public TimeUnit getTimeToDisableUnit() {
            return this.timeToDisableUnit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Properties that = (Properties)o;
            if (this.averageWindowDuration != that.averageWindowDuration) {
                return false;
            }
            if (this.historySize != that.historySize) {
                return false;
            }
            if (this.historyInterval != that.historyInterval) {
                return false;
            }
            if (this.timeToDisable != that.timeToDisable) {
                return false;
            }
            if (this.averageWindowUnit != that.averageWindowUnit) {
                return false;
            }
            if (this.historyIntervalUnit != that.historyIntervalUnit) {
                return false;
            }
            return this.timeToDisableUnit == that.timeToDisableUnit;
        }

        public int hashCode() {
            int result = (int)(this.averageWindowDuration ^ this.averageWindowDuration >>> 32);
            result = 31 * result + this.averageWindowUnit.hashCode();
            result = 31 * result + this.historySize;
            result = 31 * result + (int)(this.historyInterval ^ this.historyInterval >>> 32);
            result = 31 * result + this.historyIntervalUnit.hashCode();
            result = 31 * result + (int)(this.timeToDisable ^ this.timeToDisable >>> 32);
            result = 31 * result + this.timeToDisableUnit.hashCode();
            return result;
        }
    }
}

