/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.stats;

import org.terracotta.management.model.stats.Statistic;
import org.terracotta.management.model.stats.history.AverageHistory;
import org.terracotta.management.model.stats.history.CounterHistory;
import org.terracotta.management.model.stats.history.DurationHistory;
import org.terracotta.management.model.stats.history.RateHistory;
import org.terracotta.management.model.stats.history.RatioHistory;
import org.terracotta.management.model.stats.history.SizeHistory;
import org.terracotta.management.model.stats.primitive.Average;
import org.terracotta.management.model.stats.primitive.Counter;
import org.terracotta.management.model.stats.primitive.Duration;
import org.terracotta.management.model.stats.primitive.Rate;
import org.terracotta.management.model.stats.primitive.Ratio;
import org.terracotta.management.model.stats.primitive.Size;

public enum StatisticType {
    COUNTER(Counter.class),
    DURATION(Duration.class),
    RATE(Rate.class),
    RATIO(Ratio.class),
    SIZE(Size.class),
    AVERAGE(Average.class),
    COUNTER_HISTORY(CounterHistory.class),
    DURATION_HISTORY(DurationHistory.class),
    RATE_HISTORY(RateHistory.class),
    RATIO_HISTORY(RatioHistory.class),
    SIZE_HISTORY(SizeHistory.class),
    AVERAGE_HISTORY(AverageHistory.class);

    private final Class<? extends Statistic<?, ?>> clazz;

    private StatisticType(Class<? extends Statistic<?, ?>> clazz) {
        this.clazz = clazz;
    }

    public Class<? extends Statistic<?, ?>> getClazz() {
        return this.clazz;
    }

    public String getTypeName() {
        return this.clazz.getSimpleName();
    }

    public static StatisticType fromClass(Class<? extends Statistic<?, ?>> clazz) {
        for (StatisticType type : StatisticType.values()) {
            if (type.clazz != clazz) continue;
            return type;
        }
        throw new IllegalArgumentException("Statistic type not found: " + clazz);
    }
}

