/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.stats;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.terracotta.management.model.Objects;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.model.stats.Statistic;

public final class ContextualStatistics
implements Iterable<Statistic<?, ?>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Statistic<?, ?>> statistics;
    private final String capability;
    private final Context context;

    public ContextualStatistics(String capability, Context context, Map<String, Statistic<?, ?>> statistics) {
        this.statistics = new HashMap(Objects.requireNonNull(statistics));
        this.context = Objects.requireNonNull(context);
        this.capability = Objects.requireNonNull(capability);
    }

    public String getCapability() {
        return this.capability;
    }

    public int size() {
        return this.statistics.size();
    }

    public boolean isEmpty() {
        return this.statistics.isEmpty();
    }

    @Override
    public Iterator<Statistic<?, ?>> iterator() {
        return this.statistics.values().iterator();
    }

    public Map<String, Statistic<?, ?>> getStatistics() {
        return this.statistics;
    }

    public <T extends Statistic<?, ?>> T getStatistic(Class<T> type) throws NoSuchElementException {
        Map<String, T> filtered = this.getStatistics(type);
        if (filtered.size() != 1) {
            throw new NoSuchElementException(type.getName());
        }
        return (T)((Statistic)filtered.values().iterator().next());
    }

    public <T extends Statistic<?, ?>> T getStatistic(Class<T> type, String name) throws NoSuchElementException {
        Map<String, T> filtered = this.getStatistics(type);
        Statistic stat = (Statistic)filtered.get(name);
        if (stat == null) {
            throw new NoSuchElementException(name + ":" + type.getName());
        }
        return (T)stat;
    }

    public <T extends Statistic<?, ?>> Map<String, T> getStatistics(Class<T> type) {
        LinkedHashMap<String, T> filtered = new LinkedHashMap<String, T>();
        for (Map.Entry<String, Statistic<?, ?>> entry : this.statistics.entrySet()) {
            if (!type.isInstance(entry.getValue())) continue;
            filtered.put(entry.getKey(), type.cast(entry.getValue()));
        }
        return filtered;
    }

    public Context getContext() {
        return this.context;
    }

    public String toString() {
        return "ContextualStatistics{capability='" + this.capability + '\'' + ", context=" + this.context + ", statistics=" + this.statistics + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualStatistics that = (ContextualStatistics)o;
        if (!((Object)this.statistics).equals(that.statistics)) {
            return false;
        }
        if (!this.capability.equals(that.capability)) {
            return false;
        }
        return this.context.equals(that.context);
    }

    public int hashCode() {
        int result = ((Object)this.statistics).hashCode();
        result = 31 * result + this.capability.hashCode();
        result = 31 * result + this.context.hashCode();
        return result;
    }
}

