/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.capabilities;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.terracotta.management.model.Objects;
import org.terracotta.management.model.capabilities.Capability;
import org.terracotta.management.model.capabilities.context.CapabilityContext;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;

public final class DefaultCapability
implements Capability,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Collection<Descriptor> descriptors;
    private final CapabilityContext capabilityContext;

    public DefaultCapability(String name, CapabilityContext capabilityContext, Descriptor ... descriptors) {
        this(name, capabilityContext, Arrays.asList(descriptors));
    }

    public DefaultCapability(String name, CapabilityContext capabilityContext, Collection<Descriptor> descriptors) {
        this.name = Objects.requireNonNull(name);
        this.descriptors = Objects.requireNonNull(descriptors);
        this.capabilityContext = Objects.requireNonNull(capabilityContext);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Descriptor> getDescriptors() {
        return this.descriptors;
    }

    @Override
    public CapabilityContext getCapabilityContext() {
        return this.capabilityContext;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Capability{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", context=").append(this.capabilityContext);
        sb.append(", descriptors=").append(this.descriptors);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCapability that = (DefaultCapability)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!((Object)this.descriptors).equals(that.descriptors)) {
            return false;
        }
        return this.capabilityContext.equals(that.capabilityContext);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + ((Object)this.descriptors).hashCode();
        result = 31 * result + this.capabilityContext.hashCode();
        return result;
    }
}

